/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer.editors;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author morin
 *         Date: 26 nov. 2009
 *         Time: 19:05:06
 */
public class CurrencyEditorModel extends VradiEditorModel<String> {
    /**
     * Logger
     */
    static private final Log log = LogFactory.getLog(CurrencyEditorModel.class);

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_AMOUNT = "amount";
    public static final String PROPERTY_CURRENCY = "currency";

    protected Float amount;
    protected String currency;

    public Float getAmount() {
        return amount;
    }

    public void setAmount(Float amount) {
        Float oldValue = this.amount;
        this.amount = amount;
        pcs.firePropertyChange(PROPERTY_AMOUNT, oldValue, amount);
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        String oldValue = this.currency;
        this.currency = currency;
        pcs.firePropertyChange(PROPERTY_CURRENCY, oldValue, currency);
    }

    @Override
    public String getValue() {
        return amount + " " + currency;
    }

    @Override
    public void setValue(String value) {
        String oldValue = getValue();
        if (value != null) {
            String[] splitted = value.split("\\s+");
            try {
                Float amount = Float.parseFloat(splitted[0]);
                setAmount(amount);
                StringBuffer currency = new StringBuffer();
                for (int i = 1; i < splitted.length; i++) {
                    currency.append(splitted[i]).append(" ");
                }
                setCurrency(currency.toString().trim());
            } catch (NumberFormatException eee) {
                if (log.isErrorEnabled()) {
                    log.error("the first token is not a number : " + eee);
                }
            }
        }
        pcs.firePropertyChange(PROPERTY_VALUE, oldValue, value);
    }

}