/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class VradiTabHeader extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ID = "id";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK2Uv2/TQBTHL6FJmv6AtimhiCKFtmLDQWJBaiktRVWpUqiaClVk4Wxfmqsc3/Xu3JoOiD+BPwF2FiQ2JsTAzMCC+BcQYmBFvLPzowGTWJgMdnz33ue+772v/eorykiBrhxg3zeE5yraJMbm6t7eA/OAWOoukZagXDGBwl8qjdI1NGp31qVC87WKTi+30strrMmZS9xT2YsVNCLVE4fIBiFKocu9GZaU5Wpne9HnnmhTO6KiqC++f0s/t5+9TCPkc1CnSykNyupWMlRBaWorNAUnHeGyg919kCGouw96x/XamoOlvI+b5BA9RbkKynIsAKbQXPySA0aQ73OFcgu72HTIdYUMizWNA09Q2cTCahBpHAlsU8OjBqvXiTAe6keI3iDYJoLzAJJVoeYJLc/Qko1Qcnc/42CTOFCWDvENeQy7xmZFL+qIfCcwbxOFrQYcoVChJ/iOpxRze6OHLYdJAsH6ebq1J9Clnn7DJI3uJLutTtVQRniwrNBM7c/h78BWOPaZ38augcHuz2Lh09svb9bbs74AZ5+PDD1lVZgBF4wToag++lw4aE9Rp7yF+WIN5SVxwOeBj2cjhFVb2yAOzpsMmq7TjQ0sG4DI5D6/e198/PEMSq+jEYdhex3r+HsorxoCusAc2+e3VwJFY8fDcJ3Q2hTKMo4PPejR1BJ1HeqSElYwSNNTZNmHRsxGNKKjxsx/+FGovl5pNyMF4i7+NbzbkMwjlA1PC6zfcnWk1Ue5JJ7Nuu6N8nNK30d4y3uzwbUUVW2+zlx1TdKTAD/ve/q2ECjX/64GoImBIL08l4ig0OSRtoOFnVWH7rtNeGkTAqfbwF3iq20mqaLhu5OAOUQtaBg6u2RjhUsmdW14L5ejeYUYvHGTCfiIbGPqKmL3ERcHliOu/oYlxYzVmeXJ/yOp2GCCnkDLYk9hMHWQ2WL1nQsC33JB7GrL+/88RL18I3FBNxMTbvWpohiLsNZHQzzCRmLCVmLCTmJCP3PFI9QSz6Kfo+IR+jlKE34B+mb7jWMKAAA=";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.offer.VradiTabHeader.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton closeTab;
    protected javax.swing.JButton detachTab;
    protected java.lang.String id;
    protected javax.swing.JLabel label;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private VradiTabHeader $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public VradiTabHeader() {
        $initialize();
    }

    public VradiTabHeader(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getCloseTab() {
        return closeTab;
    }

    public javax.swing.JButton getDetachTab() {
        return detachTab;
    }

    public java.lang.String getId() {
        return id;
    }

    public javax.swing.JLabel getLabel() {
        return label;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setId(java.lang.String newValue) {
        java.lang.String oldValue = this.id;
        this.id = newValue;
        firePropertyChange(PROPERTY_ID, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createCloseTab() {
        $objectMap.put("closeTab", closeTab = new javax.swing.JButton());
        
        closeTab.setName("closeTab");
        closeTab.setBorderPainted(false);
        closeTab.setEnabled(true);
        closeTab.setFocusPainted(false);
        closeTab.setHorizontalTextPosition(0);
        closeTab.setOpaque(true);
        closeTab.setVerticalAlignment(0);
        closeTab.setVerticalTextPosition(0);
    }

    protected void createDetachTab() {
        $objectMap.put("detachTab", detachTab = new javax.swing.JButton());
        
        detachTab.setName("detachTab");
        detachTab.setBorderPainted(false);
        detachTab.setEnabled(true);
        detachTab.setFocusPainted(false);
        detachTab.setHorizontalTextPosition(0);
        detachTab.setOpaque(true);
        detachTab.setVerticalAlignment(0);
        detachTab.setVerticalTextPosition(0);
    }

    protected void createId() {
        $objectMap.put("id", id = null);
    }

    protected void createLabel() {
        $objectMap.put("label", label = new javax.swing.JLabel());
        
        label.setName("label");
        if (label.getFont() != null) {
            label.setFont(label.getFont().deriveFont((float) 12));
        }
        label.setOpaque(false);
        label.setVerticalAlignment(0);
        label.setVerticalTextPosition(0);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $Table0
        add(label, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        add(detachTab, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(2, 15, 0, 0), 0, 0));
        add(closeTab, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(2, 15, 0, 0), 0, 0));
        
        // apply 4 property setters
        detachTab.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("detach"));
        detachTab.setPreferredSize(new Dimension(16,16));
        closeTab.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("closeTab"));
        closeTab.setPreferredSize(new Dimension(16,16));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$Table0", this);
        createId();
        createLabel();
        createDetachTab();
        createCloseTab();
        // inline creation of $Table0
        setName("$Table0");
        setOpaque(false);
        
        $completeSetup();
    }

}