/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import java.io.IOException;
import java.io.Writer;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.JSONWriter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;

class PHPWriter
extends JSONWriter {
    public PHPWriter(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp) {
        super(writer, req, rsp);
    }

    public void writeNamedList(String name, NamedList val) throws IOException {
        this.writeNamedListAsMapMangled(name, val);
    }

    public void writeMapOpener(int size) throws IOException {
        this.writer.write("array(");
    }

    public void writeMapCloser() throws IOException {
        this.writer.write(')');
    }

    public void writeArrayOpener(int size) throws IOException {
        this.writer.write("array(");
    }

    public void writeArrayCloser() throws IOException {
        this.writer.write(')');
    }

    public void writeNull(String name) throws IOException {
        this.writer.write("null");
    }

    protected void writeKey(String fname, boolean needsEscaping) throws IOException {
        this.writeStr(null, fname, needsEscaping);
        this.writer.write('=');
        this.writer.write('>');
    }

    public void writeStr(String name, String val, boolean needsEscaping) throws IOException {
        if (needsEscaping) {
            this.writer.write('\'');
            block3: for (int i = 0; i < val.length(); ++i) {
                char ch = val.charAt(i);
                switch (ch) {
                    case '\'': 
                    case '\\': {
                        this.writer.write('\\');
                        this.writer.write(ch);
                        continue block3;
                    }
                    default: {
                        this.writer.write(ch);
                    }
                }
            }
            this.writer.write('\'');
        } else {
            this.writer.write('\'');
            this.writer.write(val);
            this.writer.write('\'');
        }
    }
}

