package com.jurismarches.vradi.ui.offer.validators;

import com.opensymphony.xwork2.util.URLUtil;
import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.validators.URLValidator;

/**
 * UrlValidator of XWork check if value start with "http://"
 * This one check if it's an valid simple url (like : www.codelutin.com)
 *
 */
public class SimpleUrlValidator extends URLValidator {

    public void validate(Object object) throws ValidationException {
        String fieldName = getFieldName();
        Object value = this.getFieldValue(fieldName, object);

        // if there is no value - don't do comparison
        // if a value is required, a required validator should be added to the field
        if (value == null || value.toString().length() == 0) {
            return;
        }

        // To allow www.codelutin.com for exemple
        String urlString = (String) value;
        if (!urlString.matches("[a-z]+://.+")) {
            urlString = "http://" + urlString;
        }

        // TODO SLE 11/08/2010: Write better validator base on regex 
        if (!(value.getClass().equals(String.class)) || !URLUtil.verifyUrl(urlString)) {
            addFieldError(fieldName, object);
        }
    }

}
