package com.jurismarches.vradi.ui.email.loadors;

import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.ui.tree.loadors.AbstractVradiNodeLoadors;
import jaxx.runtime.swing.nav.NavDataProvider;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.WikittyProxy;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public abstract class AbstractEmailNodeLoador<B extends BusinessEntity> extends AbstractVradiNodeLoadors<B> {

    protected AbstractEmailNodeLoador(Class<B> beanType) {
        super(beanType);
    }

    public List<Sending> getSendingList(NavDataProvider dataProvider, String sessionId) {

        // Get proxy
        WikittyProxy proxy = getProxy(dataProvider);

        // Restore session
        Session session = proxy.restore(Session.class, sessionId);

        // Get all sending ids
        Set<String> sendingIdsSet = session.getSending();
        if (sendingIdsSet == null) {
            return new ArrayList<Sending>();
        }
        
        List<String> sendingIds = new ArrayList<String>(sendingIdsSet);

        // Restore sendings
        return proxy.restore(Sending.class, sendingIds);
    }
}
