/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.renderer;

import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import java.awt.Color;
import java.awt.Component;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;

public class ThesaurusHighlighter
extends AbstractHighlighter
implements TreeCellRenderer,
ListCellRenderer {
    private static final Log log = LogFactory.getLog(ThesaurusHighlighter.class);
    boolean isProposition = false;
    protected DefaultListCellRenderer delegate = new DefaultListCellRenderer();
    protected Map<Integer, Color> colors;

    public ThesaurusHighlighter() {
        this(false);
    }

    public ThesaurusHighlighter(boolean isProposition) {
        this.isProposition = isProposition;
        this.updateColors();
    }

    protected Component doHighlight(Component component, ComponentAdapter adapter) {
        int depth = adapter.getDepth();
        Color color = this.getDepthColor(depth);
        if (color != null) {
            component.setForeground(color);
        }
        return component;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (!(value instanceof NavigationTreeNode)) {
            return new JLabel(value.toString());
        }
        NavigationTreeNode node = (NavigationTreeNode)value;
        VradiThesaurusDTO thesaurus = (VradiThesaurusDTO)node.getBean();
        if (thesaurus == null) {
            return new JLabel(value.toString());
        }
        int depth = thesaurus.getDepth();
        Color color = this.getDepthColor(depth);
        String text = thesaurus.getOrderName();
        JLabel jLabel = new JLabel(text);
        if (color != null) {
            jLabel.setForeground(color);
        }
        return jLabel;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        VradiThesaurusDTO thesaurus;
        if (value instanceof NavigationTreeNode) {
            NavigationTreeNode node = (NavigationTreeNode)value;
            thesaurus = (VradiThesaurusDTO)node.getBean();
        } else if (value instanceof VradiThesaurusDTO) {
            thesaurus = (VradiThesaurusDTO)value;
        } else {
            return new JLabel(value.toString());
        }
        if (thesaurus == null) {
            return new JLabel(value.toString());
        }
        int depth = thesaurus.getDepth();
        Color color = this.getDepthColor(depth);
        String text = thesaurus.getOrderName();
        if (this.isProposition) {
            text = thesaurus.getNamePath("/");
        }
        JLabel jLabel = (JLabel)this.delegate.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
        if (color != null) {
            jLabel.setForeground(color);
        }
        return jLabel;
    }

    public Color getDepthColor(int depth) {
        return this.colors.get(depth);
    }

    public void updateColors() {
        this.colors = VradiHelper.getColorsThesaurusFromProperties();
    }
}

