/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.email;

import com.jurismarches.vradi.entities.Client;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FormEmailContentTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(FormEmailContentTableModel.class);
    protected List<FormEmailContent> data = new ArrayList<FormEmailContent>();
    protected boolean valueIsAdjusting;

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void clear() {
        this.data.clear();
        if (!this.valueIsAdjusting) {
            this.fireTableDataChanged();
        }
    }

    public boolean isValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        this.valueIsAdjusting = valueIsAdjusting;
    }

    public List<FormEmailContent> getData() {
        return new ArrayList<FormEmailContent>(this.data);
    }

    public void addEntry(String formName, List<Client> clients) {
        FormEmailContent clientContent = new FormEmailContent();
        clientContent.formName = formName;
        clientContent.clients.addAll(clients);
        for (Client client : clients) {
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("adding client : " + client.getName() + " in form " + formName));
        }
        this.data.add(clientContent);
        if (this.isValueIsAdjusting()) {
            int newIndex = this.data.size() - 1;
            this.fireTableRowsInserted(newIndex, newIndex);
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        this.ensureColumnIndex(columnIndex);
        this.ensureRowIndex(rowIndex);
        FormEmailContent value = this.data.get(rowIndex);
        Object result = null;
        switch (columnIndex) {
            case 0: {
                result = value.formName;
                break;
            }
            case 1: {
                result = value.clients;
            }
        }
        return result;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.ensureColumnIndex(columnIndex);
        this.ensureRowIndex(rowIndex);
        FormEmailContent value = this.data.get(rowIndex);
        value.clients.clear();
        value.clients.addAll((Set)aValue);
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    protected void ensureRowIndex(int rowIndex) {
        if (rowIndex >= this.getRowCount()) {
            throw new ArrayIndexOutOfBoundsException("rowIndex (" + rowIndex + ") can not be greater than " + this.getRowCount());
        }
    }

    protected void ensureColumnIndex(int columnIndex) {
        if (columnIndex >= this.getColumnCount()) {
            throw new ArrayIndexOutOfBoundsException("columnIndex (" + columnIndex + ") can not be greater than " + this.getColumnCount());
        }
    }

    protected class FormEmailContent {
        protected String formName = null;
        protected Set<Client> clients = new HashSet<Client>();

        protected FormEmailContent() {
        }
    }
}

