/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.models.ModifThesaurusModel;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import com.jurismarches.vradi.ui.OfferEditHandler;
import com.jurismarches.vradi.ui.OfferEditUI;
import com.jurismarches.vradi.ui.OfferListHandler;
import com.jurismarches.vradi.ui.OfferListUI;
import com.jurismarches.vradi.ui.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.ThesaurusUI;
import com.jurismarches.vradi.ui.UIHelper;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.ThesaurusEditUI;
import com.jurismarches.vradi.ui.admin.ThesaurusPathChooserUI;
import com.jurismarches.vradi.ui.admin.content.AdminThesaurusUI;
import com.jurismarches.vradi.ui.search.SearchHandler;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.TreeNodeImpl;

public class ThesaurusHandler {
    private static Log log = LogFactory.getLog(ThesaurusHandler.class);
    public static String PREFIX_THESAURUS = "thesaurus";
    public static String PREFIX_EDIT = "edit";
    public static String PREFIX_MOVE = "move";

    public ThesaurusUI initUI(JAXXContext rootContext, VradiThesaurusDTO rootThesaurus, Form bean) {
        return this.initUI(rootContext, rootThesaurus, bean, false);
    }

    public ThesaurusUI initUI(JAXXContext rootContext, VradiThesaurusDTO rootThesaurus, Form bean, boolean deletable) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext);
        context.add((Object)this);
        ThesaurusUI ui = new ThesaurusUI((JAXXContext)context, rootThesaurus);
        ui.setDeletable(deletable);
        ui.setBean(bean);
        return ui;
    }

    public void initThesaurusDef() {
        VradiStorageService service = ServiceHelper.getVradiStorageService();
        TreeNode rootThesaurus = null;
        try {
            rootThesaurus = service.getRootThesaurus();
        }
        catch (TechnicalException e) {
            log.error((Object)"Cant get root thesaurus : ", (Throwable)e);
        }
        VradiThesaurusDTO vradiThesaurusDTO = new VradiThesaurusDTO();
        vradiThesaurusDTO.fromWikitty(rootThesaurus);
        VradiContext.THESAURUS_ENTRY_DEF.setContextValue((JAXXContext)VradiContext.get(), (Object)vradiThesaurusDTO);
        if (log.isDebugEnabled()) {
            vradiThesaurusDTO.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    log.debug((Object)("Property " + evt.getPropertyName() + " of def thesaurus changed, old value : " + evt.getNewValue() + " old : " + evt.getOldValue()));
                }
            });
        }
    }

    ThesaurusUI getUI(JAXXContext context) {
        if (context instanceof ThesaurusUI) {
            return (ThesaurusUI)context;
        }
        return null;
    }

    public VradiThesaurusDTO findThesaurusInRef(JAXXContext context, String wikityId) {
        VradiThesaurusDTO root = (VradiThesaurusDTO)VradiContext.THESAURUS_ENTRY_DEF.getContextValue(context);
        return root.findThesaurus(wikityId);
    }

    protected JPanel getThesaurusContainer(JAXXContext context) {
        return this.getUI(context).getParentContainer(OfferEditUI.class).getThesaurus();
    }

    protected OfferEditUI getEditUI(JAXXContext context) {
        return UIHelper.getHandler(context, OfferEditHandler.class).getUI(context);
    }

    protected OfferListUI getListUI(JAXXContext context) {
        return UIHelper.getHandler(context, OfferListHandler.class).getUI(context);
    }

    protected NavigationTreeNode getParentNode(ThesaurusTreeHelper helper, TreePath path) {
        if (path == null) {
            return helper.getRootNode();
        }
        return (NavigationTreeNode)path.getLastPathComponent();
    }

    public void addCriteria(JAXXContext context, ThesaurusTreeHelper helper, TreePath path) {
        OfferListUI ui = this.getListUI(context);
        NavigationTreeNode parentNode = this.getParentNode(helper, path);
        VradiThesaurusDTO thesaurus = (VradiThesaurusDTO)parentNode.getBean(context);
        UIHelper.getHandler(context, SearchHandler.class).addAndPersistCriteria(context, thesaurus);
        ui.validate();
    }

    public void refreshAllThesaurus(JAXXContext context) {
        List editUIs = (List)VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Refresh ui : " + (editUIs == null ? "is null" : Integer.valueOf(editUIs.size()))));
        }
        if (editUIs != null) {
            for (OfferEditUI editUI : editUIs) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Refresh ui : " + editUI.getData().getObjet()));
                }
                OfferEditHandler offerEditHandler = UIHelper.getHandler(context, OfferEditHandler.class);
                offerEditHandler.initThesaurus(context, editUI);
                editUI.revalidate();
            }
        }
    }

    public void addThesaurusUI(JAXXContext context, TreePath path) {
        if (path != null) {
            NavigationTreeNode parentNode = (NavigationTreeNode)path.getLastPathComponent();
            VradiThesaurusDTO thesaurusParent = (VradiThesaurusDTO)parentNode.getBean(context);
            this.addThesaurusUI(context, thesaurusParent, true, true);
        }
    }

    public void addThesaurusUI(JAXXContext context, VradiThesaurusDTO root, boolean deletable, boolean save) {
        if (root != null) {
            JAXXInitialContext intitialContext = new JAXXInitialContext().add((Object)context);
            ThesaurusUI thesaurusChildUI = new ThesaurusUI((JAXXContext)intitialContext, root);
            thesaurusChildUI.setDeletable(deletable);
            this.getThesaurusContainer(context).add((Component)((Object)thesaurusChildUI));
            if (save) {
                VradiHelper.addVradiListThesaurus(root.getBean());
            }
            this.getUI(context).revalidate();
        }
    }

    public void addColumn(JAXXContext context, ThesaurusTreeHelper helper, TreePath path) {
        NavigationTreeNode node = this.getParentNode(helper, path);
        VradiThesaurusDTO thesaurus = (VradiThesaurusDTO)node.getBean(context);
        VradiHelper.addVradiListThesaurus(thesaurus.getBean());
    }

    public void closeThesaurus(ThesaurusUI thesaurusUI) {
        this.getThesaurusContainer((JAXXContext)thesaurusUI).remove((Component)((Object)thesaurusUI));
        VradiThesaurusDTO selected = (VradiThesaurusDTO)thesaurusUI.helper.getRootNode().getBean();
        VradiHelper.removeVradiListThesaurus(selected.getBean());
        this.refreshAllThesaurus((JAXXContext)thesaurusUI);
    }

    public boolean answerToSaveBeforeQuit(AdminThesaurusUI content) {
        if (content != null) {
            log.info((Object)("current content  to close " + ((Object)((Object)content)).getClass().getSimpleName() + " : " + content.isModified()));
            String msgs = content.getModifModel().getAllMsgs();
            if (content.isModified().booleanValue()) {
                int n = JOptionPane.showConfirmDialog((Component)((Object)content), I18n._((String)"vradi.admin.saveAnswer", (Object[])new Object[]{msgs}), I18n._((String)"vradi.admin.saveTitle"), 1);
                switch (n) {
                    case 1: {
                        this.cancelThesaurus((JAXXContext)content, content.getHelper(), false);
                        break;
                    }
                    case 0: {
                        this.saveThesaurus((JAXXContext)content, content.getHelper(), false);
                        break;
                    }
                    case 2: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    protected NavigationTreeNode getSelectedNode(JAXXContext context, ThesaurusTreeHelper helper) {
        NavigationTreeNode selectedNode = helper.getSelectedNode(context);
        if (selectedNode == null) {
            selectedNode = helper.getRootNode();
        }
        return selectedNode;
    }

    public boolean addChildThesaurusToSelected(JAXXContext context, ThesaurusTreeHelper helper, ModifThesaurusModel modifThesaurusModel) {
        VradiThesaurusDTO created;
        NavigationTreeNode parentNode = this.getSelectedNode(context, helper);
        if (parentNode == null) {
            parentNode = helper.getRootNode();
        }
        if ((created = this.addChildThesaurus(context, helper, parentNode)) == null) {
            return false;
        }
        modifThesaurusModel.addCreateModif(created);
        return true;
    }

    protected VradiThesaurusDTO addChildThesaurus(JAXXContext context, ThesaurusTreeHelper helper, NavigationTreeNode parentNode) {
        String name;
        VradiThesaurusDTO thesaurusParent = (VradiThesaurusDTO)parentNode.getBean(context);
        TreeNodeImpl newTreeNode = new TreeNodeImpl();
        VradiThesaurusDTO newThesaurus = new VradiThesaurusDTO();
        newThesaurus.fromWikitty((TreeNode)newTreeNode);
        newThesaurus.setParentThesaurus(thesaurusParent);
        ThesaurusEditUI edit = new ThesaurusEditUI(context);
        edit.setBean(newThesaurus);
        this.attachListener(edit, newThesaurus);
        edit.setHelper(helper);
        edit.setTitleThesaurus(I18n._((String)"vradi.adminThesaurus.creationTitle"));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating thesaurus " + newThesaurus.getName()));
        }
        edit.setVisible(true);
        if (edit.isSave().booleanValue() && (name = edit.getName()) != null && !name.isEmpty()) {
            newThesaurus.setParentThesaurus(thesaurusParent);
            thesaurusParent.addChild(newThesaurus);
            newThesaurus.setToCreate(true);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding thesaurus " + newThesaurus.getName() + " to parent " + parentNode));
            }
            NavigationTreeNode newNode = helper.getBuilder().addThesaurus(context, parentNode, newThesaurus);
            helper.expendNode(context, parentNode);
            return newThesaurus;
        }
        return null;
    }

    public boolean editThesaurusSelected(JAXXContext context, ThesaurusTreeHelper helper, ModifThesaurusModel modifThesaurusModel) {
        NavigationTreeNode selectedNode = this.getSelectedNode(context, helper);
        VradiThesaurusDTO selected = (VradiThesaurusDTO)selectedNode.getBean(context);
        ThesaurusEditUI edit = new ThesaurusEditUI(context);
        this.attachListener(edit, selected, modifThesaurusModel);
        edit.setBean(selected);
        edit.setHelper(helper);
        edit.setModifModel(modifThesaurusModel);
        edit.setTitleThesaurus(I18n._((String)"vradi.adminThesaurus.editTitle", (Object[])new Object[]{selected.getName()}));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Editing thesaurus " + (selected == null ? " null " : selected.getName())));
        }
        edit.setVisible(true);
        if (edit.isSave().booleanValue()) {
            selected.setToSave(true);
            selectedNode = this.getSelectedNode((JAXXContext)edit, helper);
            helper.repaintNode(context, selectedNode);
            helper.expendNode(context, selectedNode);
            modifThesaurusModel.confirmAttributeModif();
            return true;
        }
        modifThesaurusModel.cancelAttributeModif();
        return false;
    }

    public boolean deleteThesaurusSelected(JAXXContext context, ThesaurusTreeHelper helper, ModifThesaurusModel modifThesaurusModel) {
        NavigationTreeNode selectedNode = this.getSelectedNode(context, helper);
        VradiThesaurusDTO toDelete = (VradiThesaurusDTO)selectedNode.getBean(context);
        modifThesaurusModel.addDeleteModif(toDelete);
        return this.deleteThesaurus(context, helper, selectedNode, false);
    }

    public boolean deleteThesaurusSelected(JAXXContext context, ThesaurusTreeHelper helper, boolean ask) {
        NavigationTreeNode selectedNode = this.getSelectedNode(context, helper);
        return this.deleteThesaurus(context, helper, selectedNode, ask);
    }

    public boolean deleteThesaurus(JAXXContext context, ThesaurusTreeHelper helper, NavigationTreeNode nodeToDelete, boolean ask) {
        VradiThesaurusDTO selected = (VradiThesaurusDTO)nodeToDelete.getBean(context);
        int result = 2;
        result = ask ? JOptionPane.showConfirmDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.thesaurus.askdeleteThesaurus") + selected.getRecursifName()) : 0;
        if (result == 0) {
            selected.setToDelete(true);
            helper.getBuilder().removeNodeFromParent(context, nodeToDelete);
            AdminThesaurusUI ui = (AdminThesaurusUI)context;
            NavigationTreeNode rootNode = ui.getHelper().getRootNode();
            ui.getHelper().setSelectedNode(context, rootNode);
            return true;
        }
        return false;
    }

    protected void deleteTreeNode(VradiThesaurusDTO toDelete) {
        try {
            ServiceHelper.getVradiStorageService().deleteEntity((BusinessEntity)toDelete.getBean());
        }
        catch (TechnicalException e) {
            log.error((Object)("Cant delete thesaurus : " + toDelete.getName() + " id : " + toDelete.getWikittyId()), (Throwable)e);
            ErrorDialogUI.showError((Exception)((Object)e));
        }
    }

    protected void attachListener(ThesaurusEditUI ui, VradiThesaurusDTO thesaurus) {
        this.attachListener(ui, thesaurus, null);
    }

    protected void attachListener(final ThesaurusEditUI ui, final VradiThesaurusDTO thesaurus, final ModifThesaurusModel modifThesaurusModel) {
        thesaurus.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object oldValue;
                ui.setModified(true);
                if (modifThesaurusModel != null && (oldValue = evt.getOldValue()) instanceof String) {
                    modifThesaurusModel.prepareAttributeModif(thesaurus, evt.getPropertyName(), (String)oldValue);
                }
            }
        });
    }

    public void cancelThesaurus(JAXXContext context, ThesaurusTreeHelper helper, boolean trigerredByCancelButton) {
        int confirm = -1;
        if (trigerredByCancelButton) {
            confirm = JOptionPane.showConfirmDialog((JComponent)context, I18n._((String)"vradi.admin.cancel.message"), I18n._((String)"vradi.admin.cancel.title"), 0, 2);
        }
        if (!trigerredByCancelButton || confirm == 0) {
            helper = new ThesaurusTreeHelper(context, PREFIX_EDIT);
            AdminThesaurusUI ui = (AdminThesaurusUI)context;
            ui.reinit(helper);
        }
    }

    public void saveThesaurus(JAXXContext context, ThesaurusTreeHelper helper, boolean answer) {
        AdminThesaurusUI ui;
        if (answer) {
            ui = (AdminThesaurusUI)context;
            String msgs = ui.getModifModel().getAllMsgs();
            int n = JOptionPane.showConfirmDialog((Component)((Object)ui), I18n._((String)"vradi.admin.saveThesaurusAnswer", (Object[])new Object[]{msgs}), I18n._((String)"vradi.admin.saveTitle"), 0);
            if (n == 1) {
                return;
            }
        }
        this.saveThesaurus(helper.getRootThesaurus());
        this.initThesaurusDef();
        ui = (AdminThesaurusUI)context;
        ui.setModified(false);
        ui.reinit(helper);
        UIHelper.getHandler(context, SearchHandler.class).initCriteria(context);
        this.refreshAllThesaurus(context);
    }

    protected void saveThesaurus(VradiThesaurusDTO toSave) {
        List children;
        TreeNode bean = toSave.getBean();
        if (toSave.isToDelete()) {
            this.deleteTreeNode(toSave);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saving thesaurus : " + bean.getName()));
            }
            VradiThesaurusDTO parent = toSave.getParentThesaurus();
            parent.removeChild(toSave);
        }
        if (toSave.isToSave() || toSave.isToCreate()) {
            try {
                VradiThesaurusDTO parentThesaurus = toSave.getParentThesaurus();
                if (parentThesaurus != null) {
                    TreeNode parent = parentThesaurus.getBean();
                    bean.setParent(parent.getWikittyId());
                }
                bean = (TreeNode)ServiceHelper.getVradiStorageService().updateEntity((BusinessEntity)bean);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Saving thesaurus : " + bean.getName()));
                }
            }
            catch (TechnicalException ex) {
                log.error((Object)("Cant save thesaurus : " + bean.getName() + " id : " + bean.getWikittyId() + " caused by : "), (Throwable)ex);
                ErrorDialogUI.showError((Exception)((Object)ex));
            }
            toSave.setToSave(false);
            toSave.setToCreate(false);
        }
        if ((children = toSave.getChildren()) != null) {
            for (VradiThesaurusDTO child : children) {
                if (child == null) continue;
                this.saveThesaurus(child);
            }
        }
    }

    public boolean moveThesaurus(JAXXContext context, ThesaurusTreeHelper helperFrom, ModifThesaurusModel modifThesaurusModel) {
        VradiThesaurusDTO toMove = (VradiThesaurusDTO)helperFrom.getSelectedBean(context);
        return this.moveThesaurus(context, helperFrom, toMove, modifThesaurusModel);
    }

    public boolean moveThesaurus(JAXXContext context, ThesaurusTreeHelper helperFrom, VradiThesaurusDTO beanToMove, ModifThesaurusModel modifThesaurusModel) {
        NavigationTreeNode nodeToMove = this.getSelectedNode(context, helperFrom);
        VradiThesaurusDTO rootThesaurus = helperFrom.getRootThesaurus().clone();
        boolean isDeleted = rootThesaurus.removeThesaurusRecursivly(beanToMove);
        if (log.isDebugEnabled()) {
            if (isDeleted) {
                log.debug((Object)("Thesaurus " + beanToMove.getName() + " is deleted"));
            } else {
                log.debug((Object)("Thesaurus " + beanToMove.getName() + " is not deleted (not found)"));
            }
        }
        ThesaurusTreeHelper selectHelper = new ThesaurusTreeHelper(context, rootThesaurus, PREFIX_MOVE);
        ThesaurusPathChooserUI selectUI = new ThesaurusPathChooserUI(context, selectHelper);
        selectUI.setVisible(true);
        if (selectUI.isSaved().booleanValue()) {
            NavigationTreeNode nodeParentSelected = this.getSelectedNode((JAXXContext)selectUI, selectHelper);
            VradiThesaurusDTO beanParentSelected = (VradiThesaurusDTO)nodeParentSelected.getBean();
            String parentSelectedPath = beanParentSelected.getPath(PREFIX_EDIT, helperFrom.getPathSeparator());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Searching node whith path : " + parentSelectedPath));
            }
            modifThesaurusModel.addMoveModif(beanToMove, beanToMove.getParentThesaurus().getNamePath(helperFrom.getPathSeparator()), beanToMove.getParentThesaurus().getPath(PREFIX_EDIT, helperFrom.getPathSeparator()), parentSelectedPath);
            NavigationTreeNode nodeParentSelectedFrom = helperFrom.findNode(context, parentSelectedPath);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Selected node : " + nodeParentSelected.getFullPath() + " finded node : " + nodeParentSelectedFrom.getFullPath()));
            }
            this.deleteThesaurus(context, helperFrom, nodeToMove, false);
            beanToMove.setToDelete(false);
            VradiThesaurusDTO oldParent = beanToMove.getParentThesaurus();
            oldParent.removeChild(beanToMove);
            VradiThesaurusDTO thesaurusParentFrom = (VradiThesaurusDTO)nodeParentSelectedFrom.getBean(context);
            thesaurusParentFrom.addChild(beanToMove);
            beanToMove.setParentThesaurus(thesaurusParentFrom);
            beanToMove.setToSave(true);
            NavigationTreeNode newNode = helperFrom.getBuilder().addThesaurusAndChildrenRecursivly(nodeParentSelectedFrom, beanToMove);
            helperFrom.selectNode(context, nodeParentSelectedFrom);
            if (context instanceof ThesaurusEditUI) {
                ((ThesaurusEditUI)context).getPathField().setText(beanToMove.getParentPath(helperFrom.getPathSeparator()));
            }
            return true;
        }
        return false;
    }

    public void viewApply(JAXXContext context, List<VradiThesaurusDTO> concerned) {
        UIHelper.getHandler(context, AdminHandler.class).openRequest(context, concerned);
    }
}

