/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.XmlFieldBinding;
import com.jurismarches.vradi.entities.XmlFieldBindingImpl;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.XmlStreamService;
import com.jurismarches.vradi.services.dto.VradiXmlStreamDTO;
import com.jurismarches.vradi.ui.DateFormTypeFilterHandler;
import com.jurismarches.vradi.ui.DateFormTypeFilterUI;
import com.jurismarches.vradi.ui.OfferListTableModel;
import com.jurismarches.vradi.ui.OfferListUI;
import com.jurismarches.vradi.ui.Thesaurus;
import com.jurismarches.vradi.ui.VradiCriteriaField;
import com.jurismarches.vradi.ui.admin.AdminContentUI;
import com.jurismarches.vradi.ui.admin.AdminPopupUI;
import com.jurismarches.vradi.ui.admin.AdminRequestUI;
import com.jurismarches.vradi.ui.admin.FieldTypeModel;
import com.jurismarches.vradi.ui.admin.VradiNavigationTreeHelper;
import com.jurismarches.vradi.ui.admin.content.AdminXmlStreamUI;
import com.jurismarches.vradi.ui.admin.content.FieldSelectUI;
import com.jurismarches.vradi.ui.admin.content.RequestSelectUI;
import com.jurismarches.vradi.ui.admin.content.XmlStreamFieldSelectUI;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.WikittyExtension;

public class AdminHandler {
    private static final Log log = LogFactory.getLog(AdminHandler.class);
    protected static final Comparator<Client> CLIENT_COMPARATOR = new Comparator<Client>(){

        @Override
        public int compare(Client o1, Client o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    protected static final Comparator<User> USER_COMPARATOR = new Comparator<User>(){

        @Override
        public int compare(User o1, User o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    protected static final Comparator<Group> GROUP_COMPARATOR = new Comparator<Group>(){

        @Override
        public int compare(Group o1, Group o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    protected static final Comparator<WikittyExtension> FORM_COMPARATOR = new Comparator<WikittyExtension>(){

        @Override
        public int compare(WikittyExtension o1, WikittyExtension o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    protected static final Comparator<XmlStream> XML_STREAM_COMPARATOR = new Comparator<XmlStream>(){

        @Override
        public int compare(XmlStream o1, XmlStream o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    AdminPopupUI getUI(JAXXContext context) {
        if (context instanceof AdminPopupUI) {
            return (AdminPopupUI)context;
        }
        AdminPopupUI ui = (AdminPopupUI)VradiContext.ADMIN_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    OfferListUI getOfferListUI(JAXXContext context) {
        return (OfferListUI)VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue(context);
    }

    void close(JAXXContext context) {
        AdminPopupUI ui = this.getUI(context);
        ui.setVisible(false);
        ui.dispose();
    }

    protected VradiStorageService getVradiStorageService() {
        return ServiceHelper.getVradiStorageService();
    }

    protected XmlStreamService getXmlStreamService() {
        return ServiceHelper.getXmlStreamService();
    }

    protected boolean answerToDelete(JAXXContext context, String name) {
        AdminPopupUI ui = this.getUI(context);
        int n = JOptionPane.showConfirmDialog(ui, I18n._((String)"vradi.admin.deleteAnswer") + name + " ?", I18n._((String)"vradi.admin.deleteTitle"), 0);
        return n == 0;
    }

    protected void repaintSelectedNode(JAXXContext context, VradiNavigationTreeHelper helper) {
        helper.repaintNode(context, this.getSelectedNode(context, helper));
    }

    protected NavigationTreeNode getSelectedNode(JAXXContext context, VradiNavigationTreeHelper helper) {
        return helper.getSelectedNode(context);
    }

    public void save(Object bean) {
        BusinessEntity entity = (BusinessEntity)bean;
        try {
            this.getVradiStorageService().updateEntity(entity);
        }
        catch (TechnicalException ex) {
            log.error((Object)("Cant saving bean : " + entity + " id : " + entity.getWikittyId() + " caused by : " + (Object)((Object)ex)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(JAXXContext context, VradiNavigationTreeHelper helper, Object ... beans) {
        try {
            for (Object bean : beans) {
                log.info((Object)("will save bean " + bean));
                this.save(bean);
            }
        }
        finally {
            this.repaintSelectedNode(context, helper);
        }
    }

    public boolean answerToSave(AdminContentUI<?> content) {
        if (content != null) {
            log.info((Object)("current content  to close " + content.getClass().getSimpleName() + " : " + content.isModified()));
            if (content.isModified().booleanValue()) {
                int n = JOptionPane.showConfirmDialog(content, I18n._((String)"vradi.admin.saveAnswer") + VradiHelper.getEntityName(content.getBean()) + " ?", I18n._((String)"vradi.admin.saveTitle"), 1);
                switch (n) {
                    case 1: {
                        this.cancel(content, content.getHelper());
                        break;
                    }
                    case 0: {
                        content.postSave();
                        break;
                    }
                    case 2: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(JAXXContext context, VradiNavigationTreeHelper helper, Object bean) {
        BusinessEntity entity = (BusinessEntity)bean;
        try {
            this.getVradiStorageService().deleteEntity(entity.getWikittyId());
        }
        catch (TechnicalException ex) {
            log.error((Object)("Cant delete bean : " + entity + " id : " + entity.getWikittyId() + " caused by : " + (Object)((Object)ex)));
        }
        finally {
            NavigationTreeNode parent = helper.removeChildNode(helper.getSelectedNode(context));
            helper.selectNode(context, parent);
        }
    }

    protected <B> void cancel(AdminContentUI<B> content, VradiNavigationTreeHelper helper) {
        B selectedBean = content.getSelectedEntity();
        try {
            content.openUI(helper.getSelectedNode((JAXXContext)content));
        }
        catch (Exception e) {
            log.error((Object)("Cant cancel bean : " + selectedBean + " caused by : " + e), (Throwable)e);
        }
    }

    public OfferListTableModel getResultTableModel(JTable table, List<Form> forms) {
        OfferListTableModel model = new OfferListTableModel(forms, false);
        return model;
    }

    public ComboBoxModel getTypesModel() {
        FieldTypeModel model = new FieldTypeModel();
        return model;
    }

    public ComboBoxModel getEntitiesComboBoxModel(List entities) {
        return new DefaultComboBoxModel<Object>(entities.toArray());
    }

    public void openRequest(JAXXContext context, String request) {
        AdminRequestUI requestUI = new AdminRequestUI(context);
        DateFormTypeFilterHandler criteriaHandler = new DateFormTypeFilterHandler();
        requestUI.getCriteria().add((Component)criteriaHandler.initUI(context), "Center");
        requestUI.show(request);
        RequestSelectUI ui = (RequestSelectUI)context;
        ui.setBean(requestUI.getBean());
    }

    public List<Client> getAllClients(JAXXContext context) {
        List values = (List)VradiNavigationTreeHelper.CLIENTS.getContextValue(context);
        return new ArrayList<Client>(values);
    }

    public List<User> getAllUsers(JAXXContext context) {
        List values = (List)VradiNavigationTreeHelper.USERS.getContextValue(context);
        return new ArrayList<User>(values);
    }

    public void createClient(JAXXContext context, VradiNavigationTreeHelper helper) {
        NavigationTreeNode addClient = helper.addClient(context, this.getSelectedNode(context, helper), null);
        helper.selectNode(context, addClient);
    }

    public void createUser(JAXXContext context, VradiNavigationTreeHelper helper) {
        NavigationTreeNode addUser = helper.addUser(context, this.getSelectedNode(context, helper), null);
        helper.selectNode(context, addUser);
    }

    public List<Group> getAllGroups(JAXXContext context) {
        List values = (List)VradiNavigationTreeHelper.GROUPS.getContextValue(context);
        return new ArrayList<Group>(values);
    }

    public void createGroup(JAXXContext context, VradiNavigationTreeHelper helper) {
        NavigationTreeNode addGroup = helper.addGroup(context, this.getSelectedNode(context, helper), null);
        helper.selectNode(context, addGroup);
    }

    public List<WikittyExtension> getAllForms(JAXXContext context) {
        List values = (List)VradiNavigationTreeHelper.FORMS.getContextValue(context);
        return values;
    }

    public void createFormType(JAXXContext context, VradiNavigationTreeHelper helper) {
        String name = JOptionPane.showInputDialog(this.getUI(context), (Object)I18n._((String)"vradi.adminForm.askName"));
        if (name != null && !name.isEmpty()) {
            WikittyExtension formType = new WikittyExtension(name, "0.0", "Form", new LinkedHashMap());
            NavigationTreeNode addFormType = helper.addFormType(context, this.getSelectedNode(context, helper), formType);
            helper.selectNode(context, addFormType);
        }
    }

    public void createForms(XmlStream xmlStream) {
        if (xmlStream != null) {
            try {
                String lastItem = this.getVradiStorageService().getFormsFromXmlStream(xmlStream, VradiHelper.getLastItemOfXmlStream(xmlStream.getName()));
                log.info((Object)lastItem);
                VradiHelper.setLastItemOfXmlStream(xmlStream.getName(), lastItem);
            }
            catch (TechnicalException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveFormType(JAXXContext context, VradiNavigationTreeHelper helper, List<FieldSelectUI> fields, WikittyExtension formType) {
        WikittyExtension newFormType = new WikittyExtension(formType.getName(), formType.getVersion(), formType.getRequires(), null);
        for (FieldSelectUI field : fields) {
            String name = field.getNameValue();
            log.debug((Object)name);
            if (name == null || field.getType() == null) continue;
            FieldType fieldType = field.getType().getFieldType();
            newFormType.addField(name, fieldType);
        }
        try {
            this.getVradiStorageService().updateFormType(newFormType);
            this.repaintSelectedNode(context, helper);
            ((DateFormTypeFilterUI)VradiContext.CRITERIA_UI_ENTRY_DEF.getContextValue(context)).getFormTypeSelection().setModel(new DefaultComboBoxModel<Object>(VradiHelper.getFormTypes()));
        }
        catch (TechnicalException ex) {
            log.error((Object)("Cant adding formType : " + formType.getName() + " id : " + formType.getId() + " caused by : " + (Object)((Object)ex)));
        }
    }

    public List<Form> query(String query) {
        try {
            List result = this.getVradiStorageService().findForms(query);
            return result;
        }
        catch (TechnicalException eee) {
            eee.printStackTrace();
            return null;
        }
    }

    public WikittyExtension getExtension(String extensionName) {
        try {
            return this.getVradiStorageService().getFormType(extensionName);
        }
        catch (TechnicalException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)e);
            }
            return null;
        }
    }

    public void createXmlStream(JAXXContext context, VradiNavigationTreeHelper helper) {
        NavigationTreeNode addXmlStream = helper.addXmlStream(context, this.getSelectedNode(context, helper), null);
        helper.selectNode(context, addXmlStream);
    }

    public VradiXmlStreamDTO saveXmlStream(JAXXContext context, VradiNavigationTreeHelper helper, XmlStream xmlStream, List<XmlFieldBinding> bindings) {
        VradiXmlStreamDTO result = new VradiXmlStreamDTO();
        result.fromWikitty(xmlStream);
        try {
            this.getVradiStorageService().updateXmlFieldBindings(bindings);
            xmlStream.clearXmlFieldBinding();
            for (XmlFieldBinding binding : bindings) {
                xmlStream.addXmlFieldBinding(binding.getWikittyId());
            }
            xmlStream = this.getVradiStorageService().updateXmlStream(xmlStream);
            result.fromWikitty(xmlStream);
            this.repaintSelectedNode(context, helper);
        }
        catch (TechnicalException ex) {
            log.error((Object)("Cant adding client : " + xmlStream.getUrl() + " id : " + xmlStream.getWikittyId() + " caused by : " + (Object)((Object)ex)));
        }
        return result;
    }

    public List<String> getXmlStreamAttributes(String url) {
        ArrayList<String> xmlFields = new ArrayList();
        try {
            xmlFields = this.getXmlStreamService().getRSSFields(url);
        }
        catch (TechnicalException eee) {
            eee.printStackTrace();
        }
        return xmlFields;
    }

    public List<XmlFieldBinding> getXmlStreamFields(XmlStream xmlStream) {
        ArrayList<XmlFieldBinding> result = new ArrayList();
        try {
            result = this.getVradiStorageService().getXmlFieldBindings(xmlStream);
        }
        catch (TechnicalException eee) {
            log.error((Object)eee.getMessage(), (Throwable)eee);
        }
        return result;
    }

    public WikittyExtension getFormType(List<XmlFieldBinding> bindings) {
        WikittyExtension result = null;
        for (XmlFieldBinding binding : bindings) {
            WikittyExtension formType;
            String formField = binding.getFormField();
            if (formField == null || (formType = this.getExtension(formField.substring(0, formField.lastIndexOf(46)))) == null || formType.getName().equals("Form")) continue;
            result = formType;
            break;
        }
        return result;
    }

    public void fillXmlStreamFields(final AdminXmlStreamUI ui) {
        List<XmlFieldBinding> bindings = this.getXmlStreamFields((XmlStream)ui.getBean());
        ui.getContent().removeAll();
        HashMap<String, XmlFieldBinding> bindingMap = new HashMap<String, XmlFieldBinding>();
        if (bindings != null) {
            for (XmlFieldBinding binding : bindings) {
                String formField = binding.getFormField();
                bindingMap.put(formField, binding);
            }
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        WikittyExtension formType = ui.getBean().getFormType();
        if (formType != null) {
            fieldNames.add("Form.id");
            fieldNames.add("Form.name");
            fieldNames.add("Form.datePub");
            fieldNames.add("Form.datePeremption");
            for (String fieldName : formType.getFieldNames()) {
                fieldNames.add(formType.getName() + "." + fieldName);
            }
        }
        ArrayList<String> xmlFieldNames = ui.getBean() == null || ui.getBean().getUrl() == null || ui.getBean().getUrl().isEmpty() ? new ArrayList<String>() : this.getXmlStreamAttributes(ui.getBean().getUrl());
        for (String fieldName : fieldNames) {
            XmlStreamFieldSelectUI fieldSelectUI = new XmlStreamFieldSelectUI((JAXXContext)ui);
            XmlFieldBinding binding = (XmlFieldBinding)bindingMap.get(fieldName);
            if (binding == null) {
                binding = new XmlFieldBindingImpl();
                binding.setFormField(fieldName);
            }
            fieldSelectUI.setBean(binding);
            fieldSelectUI.setXmlFields(ui.getBean().getUrl(), xmlFieldNames);
            ui.getContent().add((Component)((Object)fieldSelectUI));
            fieldSelectUI.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ui.setModified(true);
                }
            });
        }
    }

    public void createModel(JAXXContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"createModel");
        }
        try {
            List allForms = this.getVradiStorageService().getAllFormTypes();
            Collections.sort(allForms, FORM_COMPARATOR);
            VradiNavigationTreeHelper.FORMS.setContextValue(context, (Object)allForms);
            List allGroups = this.getVradiStorageService().getAllGroups();
            Collections.sort(allGroups, GROUP_COMPARATOR);
            VradiNavigationTreeHelper.GROUPS.setContextValue(context, (Object)allGroups);
            List clients = this.getVradiStorageService().getAllClients();
            Collections.sort(clients, CLIENT_COMPARATOR);
            VradiNavigationTreeHelper.CLIENTS.setContextValue(context, (Object)clients);
            List xmlStreams = this.getVradiStorageService().getAllXmlStreams();
            Collections.sort(xmlStreams, XML_STREAM_COMPARATOR);
            VradiNavigationTreeHelper.XMLSTREAMS.setContextValue(context, (Object)xmlStreams);
            ArrayList<User> users = new ArrayList<User>();
            for (Client c : clients) {
                Set usersId = c.getUser();
                if (usersId == null) continue;
                for (String userId : usersId) {
                    User user = this.getVradiStorageService().getUser(userId);
                    users.add(user);
                }
            }
            Collections.sort(users, USER_COMPARATOR);
            VradiNavigationTreeHelper.USERS.setContextValue(context, users);
        }
        catch (TechnicalException ex) {
            log.error((Object)ex);
        }
    }

    public void executeQuery(AdminRequestUI ui) {
        List<Form> forms;
        String query = ui.getRequest().getText().trim();
        if (ui.isAdvencedSearchCollapsed().booleanValue()) {
            forms = VradiHelper.executeQuery(query, null, null, null, null, null);
        } else {
            Component[] thesaurusCriteria = ui.getCriteria().getCriterias().getComponents();
            ArrayList[] thesaurus = new ArrayList[thesaurusCriteria.length];
            for (int i = 0; i < thesaurus.length; ++i) {
                Thesaurus th = (Thesaurus)((VradiCriteriaField)((Object)thesaurusCriteria[i])).getCombo().getSelectedItem();
                if (th == null) continue;
                thesaurus[i] = new ArrayList();
                thesaurus[i].add(th.getWikittyId());
                VradiHelper.getThesaurusChildren(th, thesaurus[i]);
            }
            forms = VradiHelper.executeQuery(query, (WikittyExtension)ui.getCriteria().getFormTypeSelection().getSelectedItem(), (String)ui.getCriteria().getDateTypeSelection().getSelectedItem(), ui.getCriteria().getFromDate().getDate(), ui.getCriteria().getToDate().getDate(), thesaurus);
        }
        log.debug((Object)forms.size());
        ui.getResultTableModel().setDatas(forms);
    }
}

