/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class ClientAbstract extends BusinessEntityImpl implements Client {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionClient;
    /**
     * getName :
     * @return String 
     */

    @Override
    public String getName() {
        String value = ClientHelper.getName(getWikitty());
        return value;
}

    /**
     * setName :
     * @param name 
     */

    @Override
    public void setName(String name) {
        String oldValue = getName();
        ClientHelper.setName(getWikitty(), name);
        getPropertyChangeSupport().firePropertyChange(Client.FIELD_CLIENT_NAME, oldValue, getName());
}

    /**
     * getCreationDate :
     * @return Date 
     */

    @Override
    public Date getCreationDate() {
        Date value = ClientHelper.getCreationDate(getWikitty());
        return value;
}

    /**
     * setCreationDate :
     * @param creationDate 
     */

    @Override
    public void setCreationDate(Date creationDate) {
        Date oldValue = getCreationDate();
        ClientHelper.setCreationDate(getWikitty(), creationDate);
        getPropertyChangeSupport().firePropertyChange(Client.FIELD_CLIENT_CREATIONDATE, oldValue, getCreationDate());
}

    /**
     * getAddress :
     * @return String 
     */

    @Override
    public String getAddress() {
        String value = ClientHelper.getAddress(getWikitty());
        return value;
}

    /**
     * setAddress :
     * @param address 
     */

    @Override
    public void setAddress(String address) {
        String oldValue = getAddress();
        ClientHelper.setAddress(getWikitty(), address);
        getPropertyChangeSupport().firePropertyChange(Client.FIELD_CLIENT_ADDRESS, oldValue, getAddress());
}

    /**
     * getPhone :
     * @return String 
     */

    @Override
    public String getPhone() {
        String value = ClientHelper.getPhone(getWikitty());
        return value;
}

    /**
     * setPhone :
     * @param phone 
     */

    @Override
    public void setPhone(String phone) {
        String oldValue = getPhone();
        ClientHelper.setPhone(getWikitty(), phone);
        getPropertyChangeSupport().firePropertyChange(Client.FIELD_CLIENT_PHONE, oldValue, getPhone());
}

    /**
     * getContact :
     * @return String 
     */

    @Override
    public String getContact() {
        String value = ClientHelper.getContact(getWikitty());
        return value;
}

    /**
     * setContact :
     * @param contact 
     */

    @Override
    public void setContact(String contact) {
        String oldValue = getContact();
        ClientHelper.setContact(getWikitty(), contact);
        getPropertyChangeSupport().firePropertyChange(Client.FIELD_CLIENT_CONTACT, oldValue, getContact());
}

    /**
     * ClientAbstract :
     */

    public ClientAbstract() {
        super();
}

    /**
     * ClientAbstract :
     * @param wikitty 
     */

    public ClientAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * ClientAbstract :
     * @param businessEntityImpl 
     */

    public ClientAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionClient =
                new WikittyExtension(EXT_CLIENT,
                                     "4.0", // version
                                     null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "String name unique=\"true\"", 
                                             "Date creationDate unique=\"true\"", 
                                             "String address unique=\"true\"", 
                                             "String phone unique=\"true\"", 
                                             "String contact unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionClient);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //ClientAbstract
