package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.sharengo.wikitty.BusinessEntityWikitty;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyUtil;

public class UserImpl extends com.jurismarches.vradi.entities.QueryMakerImpl implements User, QueryMaker {

    private static final long serialVersionUID = 79476278L;


    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionUser =
        new WikittyExtension(EXT_USER, "1", null,
		    WikittyUtil.buildFieldMapExtension(
				"String name unique",
				"String service unique",
				"String email unique",
				"Date creationDate unique",
				"boolean validEmail unique",
				"String address unique",
				"String phone unique",
				"Wikitty client unique",
				"Wikitty group[0-*] unique"));
    static {
        ArrayList<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        exts.add(extensionUser);

        exts.addAll(QueryMakerImpl.extensions);
        extensions = Collections.unmodifiableList(exts);
    }
 
	public UserImpl() {
		super();
	}

    public UserImpl(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public UserImpl(Wikitty wi) {
		super(wi);
	}


    public void setName(String name) {
        getWikitty().setField(EXT_USER, "name", name);
    }

    public String getName() {
        String result = getWikitty().getFieldAsString(EXT_USER, "name");
        return result;
    }


    public void setService(String service) {
        getWikitty().setField(EXT_USER, "service", service);
    }

    public String getService() {
        String result = getWikitty().getFieldAsString(EXT_USER, "service");
        return result;
    }


    public void setEmail(String email) {
        getWikitty().setField(EXT_USER, "email", email);
    }

    public String getEmail() {
        String result = getWikitty().getFieldAsString(EXT_USER, "email");
        return result;
    }


    public void setCreationDate(Date creationDate) {
        getWikitty().setField(EXT_USER, "creationDate", creationDate);
    }

    public Date getCreationDate() {
        Date result = getWikitty().getFieldAsDate(EXT_USER, "creationDate");
        return result;
    }


    public void setValidEmail(boolean validEmail) {
        getWikitty().setField(EXT_USER, "validEmail", validEmail);
    }

    public boolean getValidEmail() {
        boolean result = getWikitty().getFieldAsBoolean(EXT_USER, "validEmail");
        return result;
    }


    public void setAddress(String address) {
        getWikitty().setField(EXT_USER, "address", address);
    }

    public String getAddress() {
        String result = getWikitty().getFieldAsString(EXT_USER, "address");
        return result;
    }


    public void setPhone(String phone) {
        getWikitty().setField(EXT_USER, "phone", phone);
    }

    public String getPhone() {
        String result = getWikitty().getFieldAsString(EXT_USER, "phone");
        return result;
    }


    public void setClient(String client) {
        getWikitty().setField(EXT_USER, "client", client);
    }

    public String getClient() {
        String result = getWikitty().getFieldAsString(EXT_USER, "client");
        return result;
    }

    public Set<String> getGroup() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_USER, "group", String.class);
        return result;
    }

    public void addGroup(String element) {
        getWikitty().addToField(EXT_USER, "group", element);
    }
    
    public void removeGroup(String element) {
        getWikitty().removeFromField(EXT_USER, "group", element);
    }
    
    public void clearGroup() {
        getWikitty().clearField(EXT_USER, "group");
    }

    public Set<String> getQueries() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_QUERYMAKER, "queries", String.class);
        return result;
    }

    public void addQueries(String element) {
        getWikitty().addToField(EXT_QUERYMAKER, "queries", element);
    }
    
    public void removeQueries(String element) {
        getWikitty().removeFromField(EXT_QUERYMAKER, "queries", element);
    }
    
    public void clearQueries() {
        getWikitty().clearField(EXT_QUERYMAKER, "queries");
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }


} //UserImpl
