<%--
  #%L
  SGQ :: Web
  $Id:$
  $HeadURL:$
  %%
  Copyright (C) 2012 Herboristerie Cailleau
  %%
  Herboristerie Cailleau - Tous droits réservés
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<%@taglib uri="/struts-tags" prefix="s" %>
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
       <title>Types d'analyses</title>
    </head>
    <body>
    	<h1>Types d'analyses</h1>

        <h2>Liste des types d'analyses</h2>

        <table class="listing">
           <tr>
               <th>Catégorie</th>
               <th>Nom</th>
               <th>Durée par défaut</th>
               <th>Action</th>
           </tr>
           <s:iterator value="analyzeTypes">
               <tr>
                   <td><s:property value="key.analyzeCategory.name" /></td>
                   <td><a href="<s:url action='analyze-type-edit!input' namespace='/admin'>
                        <s:param name="analyzeTypeId"><s:property value="key.topiaId" /></s:param>
                   </s:url>"><s:property value="key.name" /></a></td>
                   <td><s:property value="key.durationDays" /> jours</td>
                   <td>
                     <s:if test="value > 0">
                       <img src="<s:url value='/img/remove_off.png' />"
                        title="Suppression impossible car <s:property value="value" /> éléments utilisent ce type d'analyse." />
                     </s:if>
                     <s:else>
                       <a href="<s:url action='analyze-type-delete' namespace='/admin'>
                        <s:param name="analyzeTypeId"><s:property value="key.topiaId" /></s:param>
                       </s:url>" class="sgq-confirm-delete"><img src="<s:url value='/img/remove.png' />" title="Supprimer" /></a>
                     </s:else>
                   </td>
               </tr>
           </s:iterator>
        </table>

        <ul>
          <li><a href="<s:url action='analyze-type-edit!input' namespace='/admin' />">Nouveau type d'analyse</a></li>
        </ul>

    	<h2>Liste des catégories d'analyses</h2>

    	<table class="listing">
    	   <tr>
    	       <th>Nom</th>
               <th>Action</th>
    	   </tr>
    	   <s:iterator value="analyzeCategories">
	    	   <tr>
                   <td><a href="<s:url action='analyze-category-edit!input' namespace='/admin'>
                        <s:param name="analyzeCategoryId"><s:property value="key.topiaId" /></s:param>
                   </s:url>"><s:property value="key.name" /></a></td>
                   <td>
                     <s:if test="value > 0">
                       <img src="<s:url value='/img/remove_off.png' />"
                        title="Suppression impossible car <s:property value="value" /> types d'analyse utilisent cette catégorie." />
                     </s:if>
                     <s:else>
                       <a href="<s:url action='analyze-category-delete' namespace='/admin'>
                        <s:param name="analyzeCategoryId"><s:property value="key.topiaId" /></s:param>
                       </s:url>" class="sgq-confirm-delete"><img src="<s:url value='/img/remove.png' />" title="Supprimer" /></a>
                     </s:else>
                   </td>
	    	   </tr>
    	   </s:iterator>
    	</table>

        <ul>
          <li><a href="<s:url action='analyze-category-edit!input' namespace='/admin' />">Nouvelle catégorie d'analyse</a></li>
        </ul>
    </body>
</html>
