/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.web.actions.user;

import com.herbocailleau.sgq.business.SgqBusinessException;
import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.web.SgqActionSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public class BatchControlAction
extends SgqActionSupport {
    private static final long serialVersionUID = 307425532542738956L;
    private static final Log log = LogFactory.getLog(BatchControlAction.class);
    protected String batchId;
    protected BatchService batchService;
    protected Batch batch;

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    @Action(results={@Result(type="stream", params={"contentType", "application/pdf", "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${filename}\""})})
    public String execute() throws Exception {
        this.batchService = (BatchService)this.newService(BatchService.class);
        this.batch = this.batchService.getBatchById(this.batchId);
        return "success";
    }

    public InputStream getInputStream() {
        File file = this.batchService.generateControlFile(this.batch);
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't generate pdf", (Throwable)ex);
            }
            throw new SgqBusinessException("Can't create input stream", (Throwable)ex);
        }
        return inputStream;
    }

    public String getFilename() {
        String filename = this.batchService.getControlFilename(this.batch);
        return filename;
    }
}

