package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.SGQDAOHelper.SGQEntityEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class ExpeditionDAOAbstract<E extends Expedition> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Expedition.class;
    }

    @Override
    public SGQEntityEnum getTopiaEntityEnum() {
        return SGQEntityEnum.Expedition;
    }

    public E findByDate(Date v) throws TopiaException {
        E result = findByProperty(Expedition.PROPERTY_DATE, v);
        return result;
    }

    public List<E> findAllByDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Expedition.PROPERTY_DATE, v);
        return result;
    }

    public E findByQuantity(double v) throws TopiaException {
        E result = findByProperty(Expedition.PROPERTY_QUANTITY, v);
        return result;
    }

    public List<E> findAllByQuantity(double v) throws TopiaException {
        List<E> result = findAllByProperty(Expedition.PROPERTY_QUANTITY, v);
        return result;
    }

    public E findByClient(String v) throws TopiaException {
        E result = findByProperty(Expedition.PROPERTY_CLIENT, v);
        return result;
    }

    public List<E> findAllByClient(String v) throws TopiaException {
        List<E> result = findAllByProperty(Expedition.PROPERTY_CLIENT, v);
        return result;
    }

    public E findByPresentation(Presentation v) throws TopiaException {
        E result = findByProperty(Expedition.PROPERTY_PRESENTATION, v);
        return result;
    }

    public List<E> findAllByPresentation(Presentation v) throws TopiaException {
        List<E> result = findAllByProperty(Expedition.PROPERTY_PRESENTATION, v);
        return result;
    }

    public E findBySource(Zone v) throws TopiaException {
        E result = findByProperty(Expedition.PROPERTY_SOURCE, v);
        return result;
    }

    public List<E> findAllBySource(Zone v) throws TopiaException {
        List<E> result = findAllByProperty(Expedition.PROPERTY_SOURCE, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

} //ExpeditionDAOAbstract<E extends Expedition>
