package com.cybelia.sandra.notifier;

import com.cybelia.sandra.SandraSchedulerConfigHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

/**
 * @author sletellier
 */
public class ThreadNotifyCron extends Thread {

    protected static final Log log = LogFactory.getLog(ThreadNotifyCron.class);

    protected String cronTopiaId;
    protected TopiaContext transaction;
    protected SandraNotifier sandraNotifier;

    public ThreadNotifyCron(SandraNotifier sandraNotifier, String cronTopiaId) {
        this.cronTopiaId = cronTopiaId;
        this.sandraNotifier = sandraNotifier;
    }

    @Override
    public void run() {
        if (log.isDebugEnabled()) {
            log.debug("Starting thread " + getName());
        }
        TopiaContext transaction = null;
        try {
            // New transaction
            TopiaContext ibuRootContext = SandraSchedulerConfigHelper.getSchedulerRootContext();
            transaction = ibuRootContext.beginTransaction();

            sandraNotifier.doNotifyCron(transaction, cronTopiaId);

        } catch (Exception eee) {
            log.error("Error notify cron", eee);
        } finally {
            // Close context
            if (transaction != null) {
                try {
                    if (!transaction.isClosed()) {
                        transaction.commitTransaction();
                        transaction.closeContext();
                    }
                } catch (TopiaException eee) {
                    log.error("Failed closing connection : ", eee);
                }
            }

            if (log.isDebugEnabled()) {
                log.debug("Stopping thread " + getName());
            }
        }
    }
}
