package com.cybelia.sandra.migration;

import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.migration.TopiaMigrationCallbackByClass;
import org.nuiton.util.Version;

/**
 * Migration between version 1.3 and 1.4.
 *
 * @author sletellier
 */
public class MigrationV13V14 extends TopiaMigrationCallbackByClass.MigrationCallBackForVersion {

    public MigrationV13V14(Version version, TopiaMigrationCallbackByClass callBack) {
        super(version, callBack);
    }

    @Override
    protected void prepareMigrationScript(TopiaContextImplementor tx, List<String> queries, boolean showSql, boolean showProgression) throws TopiaException {

        queries.add("ALTER TABLE sandra.suiviTour DROP COLUMN kmtotal;");
        queries.add("ALTER TABLE sandra.crTour DROP COLUMN kmdepart;");
        queries.add("ALTER TABLE sandra.crTour DROP COLUMN kmarrivee;");
        queries.add("ALTER TABLE sandra.crTour DROP COLUMN litresgasoil;");
        queries.add("UPDATE sandra.suiviTour SET kmdepart = 0;");
        queries.add("UPDATE sandra.suiviTour SET kmarrivee = 0;");
        queries.add("UPDATE sandra.suiviTour SET litresgasoil = 0;");
        queries.add("UPDATE sandra.taasAuthorization SET expression = 'com.cybelia.sandra.entities.Note#*' WHERE expression = 'com.cybelia.sandra.entities.Notes#*';");
    }
}
