package com.cybelia.sandra.ibu.manager;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.TourTypeModif;
import com.cybelia.sandra.entities.synchro.LogDAO;
import java.math.BigInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImpl;

/**
 * @author sletellier
 */
public class SynchNumberManager {

    protected static final Log log = LogFactory.getLog(SynchNumberManager.class);

    public static Long getNextSynchroNumber(TopiaContext transaction) throws TopiaException {
        BigInteger resultInt = (BigInteger) ((TopiaContextImpl) transaction).getHibernate().createSQLQuery("SELECT nextval('sandra.synchNumber')").uniqueResult();
        return resultInt.longValue();
    }

    public static Long getCurrentSynchroNumber(TopiaContext transaction) throws TopiaException {
        BigInteger resultInt = (BigInteger) ((TopiaContextImpl) transaction).getHibernate().createSQLQuery("SELECT last_value FROM sandra.synchnumber").uniqueResult();
        return resultInt.longValue();
    }

   public static void notifyTourCreated(ManagerInjector manager, Tour tour, String camionTopiaId, String comment) throws TopiaException {
       LogDAO logDAO = SandraDAOHelper.getLogDAO(manager.getTransaction());
       String tourTopiaId = tour.getTopiaId();
       com.cybelia.sandra.entities.synchro.Log synchroLog = logDAO.create(com.cybelia.sandra.entities.synchro.Log.PROPERTY_TOUR_TOPIA_ID, tourTopiaId);

       // else saving new log
       synchroLog.setCamionTopiaID(camionTopiaId);
       synchroLog.setTypeModif(TourTypeModif.CREATE);
       saveLog(manager, synchroLog, comment);
   }

   public static void notifyTourChange(ManagerInjector manager, Tour tour, String camionTopiaId, String comment) throws TopiaException {
       LogDAO logDAO = SandraDAOHelper.getLogDAO(manager.getTransaction());
       String tourTopiaId = tour.getTopiaId();
       com.cybelia.sandra.entities.synchro.Log synchroLog = logDAO.findByProperties(
               com.cybelia.sandra.entities.synchro.Log.PROPERTY_TOUR_TOPIA_ID, tourTopiaId,
               com.cybelia.sandra.entities.synchro.Log.PROPERTY_CAMION_TOPIA_ID, camionTopiaId);

       if (synchroLog == null) {
           synchroLog = logDAO.create(
                   com.cybelia.sandra.entities.synchro.Log.PROPERTY_TOUR_TOPIA_ID, tourTopiaId,
                   com.cybelia.sandra.entities.synchro.Log.PROPERTY_CAMION_TOPIA_ID, camionTopiaId);
       }
       
       int typeModif = TourTypeModif.MODIF;
       if (!tour.isActif()) {
           typeModif = TourTypeModif.SUPPR;
       }

       if (synchroLog.getTypeModif() == TourTypeModif.SUPPR && typeModif == TourTypeModif.SUPPR) {

           // do nothing, deletion is already notified
           return;
       }

       // else saving new log
       synchroLog.setTypeModif(typeModif);

       saveLog(manager, synchroLog, comment);
   }

   public static void saveLog(ManagerInjector manager, com.cybelia.sandra.entities.synchro.Log logToSave, String comment) {
       saveLog(manager, null, logToSave, comment);
   }

   public static void saveLog(ManagerInjector manager, String fileName, com.cybelia.sandra.entities.synchro.Log logToSave, String comment) {

       if (StringUtils.isNotEmpty(fileName)) {
           logToSave.setFichierSynchro(fileName);
       }

       if (log.isDebugEnabled()) {
           log.debug("[ManagerInjector] Saving log type " + logToSave.getTypeModif()
                   + " for tour " + logToSave.getTourTopiaID()
                   + " camion : " + logToSave.getCamionTopiaID()
                   + " with comment : " + comment);
       }

       // finally save all logs to have last synch number to solve : https://jira.groupe-glon.fr/browse/SDRAMTNC-302
       try {
           TopiaContext transaction = manager.getTransaction();
           LogDAO logDAO = SandraDAOHelper.getLogDAO(transaction);
           logToSave.setTimeStamp(System.currentTimeMillis());
           long syncNum = SynchNumberManager.getNextSynchroNumber(transaction);
           logToSave.setSynchroNumber(syncNum);

           logDAO.update(logToSave);
       } catch (TopiaException eee) {
           log.error("Failed to save synch number", eee);
       }
   }
}
