package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.Etape;
import com.cybelia.sandra.entities.EtapeDAO;
import com.cybelia.sandra.entities.LigneProduit;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import com.cybelia.sandra.ibu.manager.SynchNumberManager;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;

public class InjectorEtape implements Injector {

    private final org.apache.commons.logging.Log log = LogFactory.getLog(InjectorEtape.class);

    protected Etape etape;

    public Etape getObject() {
        return etape;
    }

    public void clear() {
        etape = null;
    }

    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
        EtapeDAO etapeDAO = SandraDAOHelper.getEtapeDAO(manager.getTransaction());

        // Get breeder concerned
        Eleveur eleveur = manager.getEleveur();

        // Recherche
        Tour tour = manager.getTour();
        etape = etapeDAO.findByNaturalId(ibu.getProduitOrdreChargement(),
                tour,
                eleveur);

        boolean created = false;

        // Création
        if (etape == null) {
            etape = etapeDAO.createByNaturalId(ibu.getProduitOrdreChargement(), tour, eleveur);
            tour.addEtapes(etape);

            // Supression des suivis pour eviter les conflis avec l'existant
            // SLE 23042010 : TMA 120 : suiviEtape manquante
            // (https://jira.groupe-glon.fr/jira/browse/SDRAMTNC-120)
            InjectorTour.deleteSuiviTour(log, manager, tour);

            created = true;

            log.info("Creating etape [" + etape.getTopiaId() + "]");
        } else {
            log.info("etape [" + etape.getTopiaId() + "]");
        }

        // Mise à jour
        etape.setEtat(ibu.getCommandeLigneEtat());
        etape.setCommentaire(ibu.getEleveurCommentaire());

        // Impact ligne produit
        LigneProduit ligneProduit = manager.getLigneProduit();

        // keep old etape
        Etape oldEtape = ligneProduit.getEtape();

        // impact new etape
        ligneProduit.setEtape(etape);
        etape.addProduits(ligneProduit);

        if (created || (oldEtape == null || !oldEtape.getTopiaId().equals(etape.getTopiaId()))) {

            // for all case, delete all suivis
            InjectorTour.deleteSuiviTour(log, manager, tour);

            String msg = "etape " + etape.getTopiaId() + " created";
            if (!created) {
                String topiaId = null;
                if (oldEtape != null) {
                    topiaId = oldEtape.getTopiaId();
                }
                msg = "etape changed old[" + topiaId + "] new[" + etape.getTopiaId() + "]";
            }

            // Maj du log courrant
            SynchNumberManager.notifyTourChange(manager,
                    tour,
                    tour.getCamion().getTopiaId(),
                    msg);

        }
    }
}
