package com.cybelia.sandra;

import com.cybelia.sandra.notifier.SandraNotifier;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.commons.mail.SimpleEmail;
import org.nuiton.topia.TopiaException;
import org.nuiton.util.ApplicationConfig;

/**
 * @author sletellier
 */
public class EmailHelper {

    private static final Log log = LogFactory.getLog(EmailHelper.class);

    public static void sendEmail(String[] to, String subject, String msg, String... attachments) {
        log.info("Mail will sent to subject : " + subject + " to " + Arrays.toString(to));
        ApplicationConfig config = SandraConfig.getConfig();

        // Création mail
        MultiPartEmail email = new MultiPartEmail();

        email.setHostName(SandraSchedulerConfigHelper.getSandraEmailHost(config));
        email.setSmtpPort(SandraSchedulerConfigHelper.getSandraEmailPort(config));
        email.setSubject(subject);
        try {
            email.setFrom(SandraSchedulerConfigHelper.getSandraEmailForm(config));
            for (String recipient : to) {
                email.addTo(recipient);
            }

            String charset = "UTF-8";

            email.setCharset(charset);
            email.addPart(msg, SimpleEmail.TEXT_PLAIN);

            for (String attachmentPath : attachments) {
                EmailAttachment attachment = new EmailAttachment();
                attachment.setPath(attachmentPath);
                email.attach(attachment);
            }

            // pour l'erreur java.lang.String.concat avec NullPointerException,
            // la solution est de supprimer -e dans le fichier .mailcap
            // envoi du mail
            email.send();

            log.info("Mail sent subject : " + subject + " to " + Arrays.toString(to));
        } catch (EmailException e) {
            String msgErr = "EmailException impossible d'envoyer le mail";
            log.fatal(msgErr, e);
            throw new RuntimeException(msgErr, e);
        }
    }

    public static void sendEmail(String to, String subject, String message, String... attachments) {
        sendEmail(new String[]{to}, subject, message, attachments);
    }

    public static void sendEmailToAdmin(String subject, String message, String... attachments) {
        sendEmail(SandraSchedulerConfigHelper.getSandraEmailTo(SandraConfig.getConfig()), subject, message, attachments);
    }

    public static void sendNotification(String name, List<String[]> datas) {
        try {
            // Extraction des donnees
            List<List<String>> reformatData = SandraHelper.reformatData(datas);

            // Creation dun string de la forme topiaId&&topiaId...
            String etapeTopiaIdsAsString = SandraHelper.convertToListForNotifier(reformatData.get(0));
            String eleveurTopiaIdsAsString = SandraHelper.convertToListForNotifier(reformatData.get(1));
            String tourTopiaIdsAsString = SandraHelper.convertToListForNotifier(reformatData.get(2));
            String camionTopiaIdsAsString = SandraHelper.convertToListForNotifier(reformatData.get(3));

            // Envoie de la notification
            ApplicationConfig config = SandraConfig.getConfig();

            SandraNotifier sandraNotifier = new SandraNotifier();
            sandraNotifier.notifyEvent(name,
                    SandraSchedulerConfigHelper.getSandraName(config),
                    SandraSchedulerConfigHelper.getSandraUrl(config),
                    etapeTopiaIdsAsString,
                    eleveurTopiaIdsAsString,
                    tourTopiaIdsAsString,
                    camionTopiaIdsAsString);

        } catch (TopiaException ex) {
            log.error("TopiaException : ", ex);
        }
    }
}
