/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.predicate;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LineString;
import java.util.List;

public class SegmentIntersectionTester {
    private LineIntersector li = new RobustLineIntersector();
    private boolean hasIntersection = false;
    private Coordinate pt00 = new Coordinate();
    private Coordinate pt01 = new Coordinate();
    private Coordinate pt10 = new Coordinate();
    private Coordinate pt11 = new Coordinate();

    public boolean hasIntersectionWithLineStrings(LineString line, List lines) {
        for (LineString testLine : lines) {
            this.hasIntersectionWithEnvelopeFilter(line, testLine);
            if (!this.hasIntersection) continue;
            break;
        }
        return this.hasIntersection;
    }

    private boolean hasIntersectionWithEnvelopeFilter(LineString line, LineString testLine) {
        CoordinateSequence seq0 = line.getCoordinateSequence();
        CoordinateSequence seq1 = testLine.getCoordinateSequence();
        Envelope lineEnv = line.getEnvelopeInternal();
        for (int i = 1; i < seq1.size() && !this.hasIntersection; ++i) {
            seq1.getCoordinate(i - 1, this.pt10);
            seq1.getCoordinate(i, this.pt11);
            if (!lineEnv.intersects(new Envelope(this.pt10, this.pt11))) continue;
            for (int j = 1; j < seq0.size() && !this.hasIntersection; ++j) {
                seq0.getCoordinate(j - 1, this.pt00);
                seq0.getCoordinate(j, this.pt01);
                this.li.computeIntersection(this.pt00, this.pt01, this.pt10, this.pt11);
                if (!this.li.hasIntersection()) continue;
                this.hasIntersection = true;
            }
        }
        return this.hasIntersection;
    }

    private boolean hasIntersection(LineString line, LineString testLine) {
        CoordinateSequence seq0 = line.getCoordinateSequence();
        CoordinateSequence seq1 = testLine.getCoordinateSequence();
        for (int i = 1; i < seq0.size() && !this.hasIntersection; ++i) {
            seq0.getCoordinate(i - 1, this.pt00);
            seq0.getCoordinate(i, this.pt01);
            for (int j = 1; j < seq1.size() && !this.hasIntersection; ++j) {
                seq1.getCoordinate(j - 1, this.pt10);
                seq1.getCoordinate(j, this.pt11);
                this.li.computeIntersection(this.pt00, this.pt01, this.pt10, this.pt11);
                if (!this.li.hasIntersection()) continue;
                this.hasIntersection = true;
            }
        }
        return this.hasIntersection;
    }
}

