/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class PagerUtil {
    public static int getTotalPage(int totalCount, int pageSize) {
        int result = (int)Math.ceil((double)totalCount / (double)pageSize);
        return result;
    }

    public static Pair<Integer, Integer> getPageBound(int totalCount, int page, int pageSize) {
        page = Math.max(page, 1);
        pageSize = Math.max(pageSize, 1);
        int start = (page - 1) * pageSize;
        int end = page * pageSize;
        end = Math.min(end, totalCount);
        Pair result = Pair.of((Object)start, (Object)end);
        return result;
    }

    public static <E> List<E> getPage(List<E> elements, int page, int pageSize) {
        Pair<Integer, Integer> bound = PagerUtil.getPageBound(elements.size(), page, pageSize);
        int start = (Integer)bound.getLeft();
        int end = (Integer)bound.getRight();
        List<E> subList = elements.subList(start, end);
        ArrayList<E> result = new ArrayList<E>(subList);
        return result;
    }

    public static void computeRecordIndexesAndPagesNumber(PagerBean bean) {
        int records = bean.getRecords();
        int pageSize = bean.getPageSize();
        Pair<Integer, Integer> pageBound = PagerUtil.getPageBound(records, bean.getPageIndex(), pageSize);
        bean.setRecordStartIndex((Integer)pageBound.getLeft());
        bean.setRecordEndIndex((Integer)pageBound.getRight());
        bean.setPagesNumber(PagerUtil.getTotalPage(records, pageSize));
    }

    public static PagerBean newPagerBean() {
        return new PagerBean();
    }

    public static class PagerBean
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected int records;
        protected int recordStartIndex;
        protected int recordEndIndex;
        protected int pageIndex;
        protected int pageSize;
        protected int pagesNumber;

        public int getRecords() {
            return this.records;
        }

        public int getRecordStartIndex() {
            return this.recordStartIndex;
        }

        public int getRecordEndIndex() {
            return this.recordEndIndex;
        }

        public int getPageIndex() {
            return this.pageIndex;
        }

        public int getPageSize() {
            return this.pageSize;
        }

        public int getPagesNumber() {
            return this.pagesNumber;
        }

        public void setRecords(int records) {
            this.records = records;
        }

        public void setRecordStartIndex(int recordStartIndex) {
            this.recordStartIndex = recordStartIndex;
        }

        public void setRecordEndIndex(int recordEndIndex) {
            this.recordEndIndex = recordEndIndex;
        }

        public void setPageIndex(int pageIndex) {
            this.pageIndex = pageIndex;
        }

        public void setPageSize(int pageSize) {
            this.pageSize = pageSize;
        }

        public void setPagesNumber(int pagesNumber) {
            this.pagesNumber = pagesNumber;
        }
    }
}

