/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.notifier;

import com.cybelia.sandra.EmailHelper;
import com.cybelia.sandra.SandraConfig;
import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.SandraSchedulerConfigHelper;
import com.cybelia.sandra.entities.Label;
import com.cybelia.sandra.entities.LabelDAO;
import com.cybelia.sandra.entities.notifier.Cron;
import com.cybelia.sandra.entities.notifier.CronDAO;
import com.cybelia.sandra.entities.notifier.Event;
import com.cybelia.sandra.entities.notifier.EventDAO;
import com.cybelia.sandra.entities.notifier.Queue;
import com.cybelia.sandra.entities.notifier.QueueDAO;
import com.cybelia.sandra.notifier.TemplateHelper;
import com.cybelia.sandra.notifier.ThreadNotifyCron;
import com.cybelia.sandra.notifier.ThreadNotifyEvent;
import com.cybelia.sandra.security.NotifierProfilManager;
import com.cybelia.sandra.security.NotifierSecurityHelper;
import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaSecurityDAOHelper;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaId;
import org.nuiton.topia.taas.entities.TaasUser;
import org.nuiton.topia.taas.entities.TaasUserDAO;
import org.nuiton.util.ApplicationConfig;

public class SandraNotifier {
    protected static final Log log = LogFactory.getLog(SandraNotifier.class);

    protected void endTransaction(TopiaContext transaction) throws TopiaException {
        transaction.commitTransaction();
        transaction.closeContext();
    }

    public void notifyEvent(String type, String ... values) throws TopiaException {
        ThreadNotifyEvent threadNotifyEvent = new ThreadNotifyEvent(new SandraNotifier(), type, values);
        threadNotifyEvent.start();
    }

    public void notifyCron(String cronTopiaId) throws TopiaException {
        ThreadNotifyCron threadNotifyCron = new ThreadNotifyCron(new SandraNotifier(), cronTopiaId);
        threadNotifyCron.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized void doNotifyEvent(TopiaContext transaction, String type, String[] values) {
        List crons = null;
        ArrayList<Queue> queues = null;
        QueueDAO queueDAO = SandraDAOHelper.getQueueDAO((TopiaContext)transaction);
        EventDAO eventDAO = SandraDAOHelper.getEventDAO((TopiaContext)transaction);
        Event event = eventDAO.findByType(type);
        Queue queue = (Queue)queueDAO.create(new Object[0]);
        queue.setEvent(event);
        queue.setDate(new Date());
        queue.addAllValues(Arrays.asList(values));
        queueDAO.update((TopiaEntity)queue);
        queues = new ArrayList<Queue>(1);
        queues.add(queue);
        if (log.isDebugEnabled()) {
            log.debug((Object)("adding queue : " + queue.getTopiaId()));
        }
        String hql = "SELECT cron FROM " + Cron.class.getName() + " cron WHERE " + "cron.enable = :enable AND cron.event.type = :type AND " + "(cron.expression IS NULL OR cron.expression = '') AND " + "(cron.dateStart IS NULL OR cron.dateStart >= :date) AND " + "(cron.dateEnd IS NULL OR cron.dateEnd <= :date)";
        crons = transaction.findAll(hql, new Object[]{"enable", true, "type", type, "date", new Date()});
        if (transaction == null) return;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("crons : " + crons + " queues not null : " + queues != null ? 1 : 0));
            }
            if (crons != null && queues != null) {
                for (Cron cron : crons) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("cron : " + cron.getTopiaId()));
                    }
                    this.notifyCron(transaction, cron, queues);
                }
                return;
            }
            if (transaction == null) return;
            this.endTransaction(transaction);
            return;
        }
        catch (Exception eee) {
            log.error((Object)"Topia exception, trying to reopening connection", (Throwable)eee);
            return;
        }
        finally {
            if (transaction != null) {
                try {
                    this.endTransaction(transaction);
                }
                catch (TopiaException eee) {
                    log.error((Object)"Topia exception, trying to reopening connection", (Throwable)eee);
                }
            }
        }
        catch (TopiaException te) {
            log.error((Object)"Topia exception : ", (Throwable)te);
            if (transaction == null) return;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("crons : " + crons + " queues not null : " + queues != null ? 1 : 0));
                }
                if (crons != null && queues != null) {
                    for (Cron cron : crons) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("cron : " + cron.getTopiaId()));
                        }
                        this.notifyCron(transaction, cron, queues);
                    }
                    return;
                } else {
                    if (transaction == null) return;
                    this.endTransaction(transaction);
                }
                return;
            }
            catch (Exception eee) {
                log.error((Object)"Topia exception, trying to reopening connection", (Throwable)eee);
                return;
            }
            finally {
                if (transaction != null) {
                    try {
                        this.endTransaction(transaction);
                    }
                    catch (TopiaException eee) {
                        log.error((Object)"Topia exception, trying to reopening connection", (Throwable)eee);
                    }
                }
            }
            catch (Throwable throwable) {
                if (transaction == null) throw throwable;
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("crons : " + crons + " queues not null : " + queues != null ? 1 : 0));
                    }
                    if (crons != null && queues != null) {
                        for (Cron cron : crons) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("cron : " + cron.getTopiaId()));
                            }
                            this.notifyCron(transaction, cron, queues);
                        }
                        throw throwable;
                    } else {
                        if (transaction == null) throw throwable;
                        this.endTransaction(transaction);
                    }
                    throw throwable;
                }
                catch (Exception eee) {
                    log.error((Object)"Topia exception, trying to reopening connection", (Throwable)eee);
                    throw throwable;
                }
                finally {
                    if (transaction != null) {
                        try {
                            this.endTransaction(transaction);
                        }
                        catch (TopiaException eee) {
                            log.error((Object)"Topia exception, trying to reopening connection", (Throwable)eee);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doNotifyCron(TopiaContext transaction, String cronTopiaId) {
        try {
            CronDAO cronDAO = SandraDAOHelper.getCronDAO((TopiaContext)transaction);
            Cron cron = (Cron)cronDAO.findByTopiaId(cronTopiaId);
            String hqlQueue = "SELECT queue FROM " + Queue.class.getName() + " queue WHERE " + "queue.event = :event AND " + "queue NOT IN (SELECT q FROM " + Queue.class.getName() + " q JOIN q.cron AS cron WHERE cron = :cron) AND " + "queue.date >= :date";
            List queues = transaction.findAll(hqlQueue, new Object[]{"event", cron.getEvent(), "cron", cron, "date", cron.getTopiaCreateDate()});
            if (!queues.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("NotifyCron " + cron.getTopiaId() + " in queue " + queues.size()));
                }
                this.notifyCron(transaction, cron, queues);
            } else if (log.isInfoEnabled()) {
                log.info((Object)("Nothing to do for cron " + cron.getTopiaId()));
            }
        }
        catch (TopiaException te) {
            log.error((Object)"NotifyCron error", (Throwable)te);
        }
        catch (Exception te) {
            log.error((Object)"NotifyCron error", (Throwable)te);
        }
        finally {
            try {
                this.endTransaction(transaction);
            }
            catch (TopiaException ex) {
                log.error((Object)"Topia exception : ", (Throwable)ex);
            }
        }
    }

    protected void notifyCron(TopiaContext transaction, Cron cron, List<Queue> queues) throws Exception {
        for (Queue queue : queues) {
            queue.addCron(cron);
        }
        TaasUserDAO userDAO = TopiaSecurityDAOHelper.getTaasUserDAO((TopiaContext)transaction);
        TaasUser author = (TaasUser)userDAO.findByTopiaId(cron.getAuthor());
        Collection recipients = cron.getRecipients();
        HashSet<String> to = new HashSet<String>();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Recipients : " + Arrays.toString(recipients.toArray())));
        }
        for (String recipient : recipients) {
            String topiaId = NotifierSecurityHelper.getTopiaIdRecipient(recipient);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Recipient : " + topiaId));
            }
            if (TopiaId.isValidId((String)topiaId)) {
                TopiaEntity entity = transaction.findByTopiaId(topiaId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("entity instanceof TaasUser : " + recipient + " topiaId + " + topiaId));
                }
                if (entity instanceof TaasUser) {
                    TaasUser user = (TaasUser)entity;
                    String email = user.getEmail();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Dest type user : " + email));
                    }
                    if (!to.add(email)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Added");
                    }
                    this.notifyUser(transaction, cron, queues, user, email);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Dest type profil");
                }
                String hql = "SELECT user FROM " + TaasUser.class.getName() + " user " + "JOIN user.principals AS principal JOIN principal.authorizations AS authorization WHERE " + "authorization.expression = :expression";
                ArrayList<String> args = new ArrayList<String>();
                args.add("expression");
                args.add(topiaId);
                if (NotifierSecurityHelper.isAdminProfil(recipient)) {
                    hql = "SELECT user FROM " + TaasUser.class.getName() + " user WHERE " + "user IN (" + hql + ") AND " + "user IN (SELECT user FROM " + TaasUser.class.getName() + " user " + "JOIN user.principals AS principal WHERE " + "principal.name = :profilAdmin)";
                    String profilAdmin = NotifierSecurityHelper.getAdminProfilName(topiaId);
                    args.add("profilAdmin");
                    args.add(profilAdmin);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Profil admin request : " + hql + " profilAdmin " + profilAdmin + " exp " + topiaId));
                    }
                } else {
                    log.info((Object)("Profil request : " + hql + " exp " + topiaId));
                }
                List users = transaction.findAll(hql, args.toArray());
                for (TaasUser user : users) {
                    String email = user.getEmail();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Result mail " + email));
                    }
                    if (!to.add(email)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(email + " added"));
                    }
                    this.notifyUser(transaction, cron, queues, user, email);
                }
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Dest libre : " + recipient));
            }
            if (!to.add(recipient)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)"added");
            }
            this.notifyUser(transaction, cron, queues, author, recipient);
        }
        if (log.isInfoEnabled() && to.isEmpty()) {
            log.info((Object)("No recipient cron " + cron.getTopiaId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyUser(TopiaContext transaction, Cron cron, List<Queue> queues, TaasUser user, String to) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("NotifieUser queue size : " + queues.size() + " for user " + user.getLogin()));
        }
        ArrayList<Map<String, Object>> events = new ArrayList<Map<String, Object>>(queues.size());
        ArrayList<String> pjs = new ArrayList<String>();
        for (Queue queue : queues) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Queue : " + queue.getTopiaId()));
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            boolean secure = false;
            ArrayList variables = new ArrayList(queue.getEvent().getVariables());
            ArrayList finalVariable = new ArrayList(variables);
            ArrayList values = new ArrayList(queue.getValues());
            HashMap<Integer, boolean[]> cachedUnauthorized = new HashMap<Integer, boolean[]>();
            HashMap cachedEntities = new HashMap();
            try {
                int index = 0;
                for (String variable : variables) {
                    String value = (String)values.get(index);
                    ++index;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Variable : " + variable));
                    }
                    if (this.isPj(variable)) {
                        String statsPath = SandraSchedulerConfigHelper.getNotifPath(SandraConfig.getConfig());
                        File statsDir = new File(statsPath);
                        SimpleDateFormat format = new SimpleDateFormat("yyMMdd");
                        String now = format.format(new Date());
                        String fileName = variable.replace("{date}", now);
                        String statPath = statsDir + File.separator + fileName;
                        File statFile = new File(statPath);
                        FileWriter writer = null;
                        try {
                            writer = new FileWriter(statFile, false);
                            writer.write(value);
                        }
                        finally {
                            if (writer != null) {
                                writer.close();
                            }
                        }
                        pjs.add(statPath);
                        finalVariable.remove(variable);
                        continue;
                    }
                    if (value != null && this.isValidListOfId(value)) {
                        boolean[] unauthorized;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"list entity");
                        }
                        String[] topiaIds = value.split("\\&\\&");
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Found in list " + variable + " " + topiaIds.length + " values " + "(" + value + ")"));
                        }
                        if ((unauthorized = (boolean[])cachedUnauthorized.get(topiaIds.length)) == null) {
                            unauthorized = new boolean[topiaIds.length];
                        }
                        Arrays.fill(unauthorized, false);
                        ArrayList<TopiaEntity> entities = new ArrayList<TopiaEntity>();
                        int lenght = topiaIds.length;
                        int cnt = 0;
                        for (String topiaid : topiaIds) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"entity");
                            }
                            TopiaEntity entity = NotifierSecurityHelper.isAdmin(user) ? transaction.findByTopiaId(topiaid) : NotifierProfilManager.getTopiaEntity(transaction, user, topiaid);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Find entity : " + entity));
                            }
                            if (entity == null) {
                                unauthorized[cnt] = true;
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("step " + variable + " is unauthorized " + topiaid));
                                }
                            }
                            entities.add(entity);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("step " + variable + " unauthorized " + (entity == null) + " " + cnt + " " + lenght));
                            }
                            ++cnt;
                        }
                        cachedUnauthorized.put(unauthorized.length, unauthorized);
                        cachedEntities.put(variable, entities);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Found in list " + variable + " " + entities.size() + " entities"));
                        }
                    } else if (value != null && TopiaId.isValidId((String)value)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"entity");
                        }
                        TopiaEntity entity = null;
                        if (NotifierSecurityHelper.isAdmin(user)) {
                            entity = transaction.findByTopiaId(value);
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Try to find entity : " + value + " from user " + user.getLogin()));
                            }
                            entity = NotifierProfilManager.getTopiaEntity(transaction, user, value);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Find entity : " + entity));
                        }
                        if (entity == null) {
                            secure = true;
                            log.warn((Object)("l'entite n'est pas autorise, arret du traitement : " + value));
                            break;
                        }
                        context.put(variable, entity);
                    } else if (this.isList(value)) {
                        String[] splited = value.split("&&");
                        context.put(variable, Arrays.asList(splited));
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("other : " + value));
                        }
                        context.put(variable, value);
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Finished Index : " + index + "/" + finalVariable.size() + " variable " + variable + " value " + value));
                }
            }
            catch (Exception e) {
                log.error((Object)"Exception : ", (Throwable)e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Context to add : " + context));
            }
            for (String variable : cachedEntities.keySet()) {
                List entities = (List)cachedEntities.get(variable);
                boolean[] unauthorized = (boolean[])cachedUnauthorized.get(entities.size());
                for (int i = unauthorized.length - 1; i >= 0; --i) {
                    if (!unauthorized[i]) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Removing entity " + i + " from list : " + variable));
                    }
                    entities.remove(i);
                }
                if (entities.isEmpty()) {
                    secure = true;
                    log.warn((Object)("Final list " + variable + " is empty"));
                    break;
                }
                log.info((Object)("Final list size " + variable + " size " + entities.size()));
                context.put(variable, entities);
            }
            if (!secure && context.size() == finalVariable.size()) {
                this.addLabelMapInContext(transaction, context);
                context.put("helper", new TemplateHelper());
                if (log.isDebugEnabled()) {
                    for (String key : context.keySet()) {
                        log.debug((Object)("context key[" + key + "] value[" + context.get(key) + "]"));
                    }
                }
                events.add(context);
                continue;
            }
            log.warn((Object)("Context is not secure : " + ((Object)context).toString() + " context size : " + context.size() + " variable size : " + finalVariable.size()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"sendTemplate");
        }
        if (!events.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Send cron " + cron.getTopiaId() + " to " + to));
            }
            this.sendTemplate(cron, events, pjs, to);
        } else if (log.isInfoEnabled()) {
            log.info((Object)("Nothing to do " + cron.getTopiaId() + " to " + to));
        }
    }

    protected void addLabelMapInContext(TopiaContext transaction, Map<String, Object> context) throws Exception {
        HashMap<String, String> labelMap = new HashMap<String, String>();
        LabelDAO labelDAO = SandraDAOHelper.getLabelDAO((TopiaContext)transaction);
        ArrayList labels = new ArrayList(labelDAO.findAll());
        for (Label lbl : new ArrayList(labels)) {
            labelMap.put(lbl.getCategorie() + "-" + lbl.getId(), lbl.getValeur());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found " + labelMap.size() + " label"));
        }
        context.put("lbl", labelMap);
    }

    protected boolean isPj(String variable) {
        return variable.matches(".+\\-\\{date\\}\\..+");
    }

    protected boolean isValidListOfId(String value) throws Exception {
        return value != null && value.matches(".*?#[0-9]+#[0-9.]+\\&\\&.*");
    }

    protected boolean isList(String value) throws Exception {
        return value != null && value.matches("(.*\\&\\&)+.*?");
    }

    public void sendTemplate(Cron cron, List<Map<String, Object>> events, List<String> pjs, String to) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sendTemplateIn");
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("events", events);
        context.put("event", events.get(0));
        ApplicationConfig appConfig = SandraConfig.getConfig();
        String dirName = SandraSchedulerConfigHelper.getNotifierTemplateDir(appConfig);
        String fileName = dirName + cron.getTemplate() + SandraSchedulerConfigHelper.getNotifierTemplateExt(appConfig);
        if (log.isDebugEnabled()) {
            log.debug((Object)("dirName : " + dirName + " fileName : " + fileName));
        }
        StringWriter content = new StringWriter();
        Configuration config = new Configuration();
        config.setDefaultEncoding("utf8");
        try {
            Template template = new Template(dirName, (Reader)new FileReader(fileName), config, "utf8");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Template encoding : " + template.getEncoding()));
            }
            Environment env = template.createProcessingEnvironment(context, (Writer)content);
            env.setOutputEncoding("utf8");
            env.process();
        }
        catch (Exception e) {
            log.error((Object)("Generating failed fileName : " + fileName + " content : " + content.toString()), (Throwable)e);
        }
        String subject = "";
        String body = "";
        StringBuffer message = content.getBuffer();
        int index = message.indexOf("\n");
        if (index != -1) {
            subject = message.substring(0, index).trim();
            body = message.substring(index).trim();
        } else {
            subject = "(no subject)";
            body = message.toString().trim();
        }
        if (!body.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("sendEmail to : " + to + " subject : " + subject));
            }
            EmailHelper.sendEmail(to, subject, body, pjs.toArray(new String[pjs.size()]));
        }
    }
}

