/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.Transporteur;
import com.cybelia.sandra.entities.TransporteurDAO;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.csv.bean.IbuCamion;
import com.cybelia.sandra.ibu.csv.bean.IbuTransporteur;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class InjectorTransporteur
implements Injector {
    protected Transporteur transporteur;

    public Transporteur getObject() {
        return this.transporteur;
    }

    @Override
    public void clear() {
        this.transporteur = null;
    }

    @Override
    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
        Camion camion = manager.getCamion();
        this.transporteur = camion.getTransporteur();
    }

    public void inject(ManagerInjector manager, IbuTransporteur ibuTransporteur) throws TopiaException {
        TransporteurDAO transporteurDAO = SandraDAOHelper.getTransporteurDAO((TopiaContext)manager.getTransaction());
        this.transporteur = transporteurDAO.findByNaturalId(ibuTransporteur.getCode(), manager.getSociete());
        if (this.transporteur != null) {
            this.transporteur.setName(ibuTransporteur.getName());
        }
    }

    public void inject(ManagerInjector manager, IbuCamion camion) throws TopiaException {
        TransporteurDAO transporteurDAO = SandraDAOHelper.getTransporteurDAO((TopiaContext)manager.getTransaction());
        this.transporteur = transporteurDAO.findByNaturalId(camion.getTransporteur(), manager.getSociete());
        if (this.transporteur == null) {
            this.transporteur = transporteurDAO.createByNaturalId(camion.getTransporteur(), manager.getSociete());
        }
    }
}

