/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.entities;

import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.sig.PointGPS;
import com.vividsolutions.jts.geom.Point;

public enum GPSStateEnum {
    GPS_LOCKED("gpsLocked"),
    GPS_EMPTY("gpsEmpty"),
    GPS_OK("gpsOk");

    private final String key;

    private GPSStateEnum(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public static GPSStateEnum getGPSState(Eleveur eleveur) {
        PointGPS gps = eleveur.getTomtomGPS();
        if (gps == null || gps.getPoint() == null) {
            return GPS_EMPTY;
        }
        Point gpsPoint = gps.getPoint();
        if (gpsPoint.getX() == 0.0 && gpsPoint.getY() == 0.0) {
            return GPS_EMPTY;
        }
        if (eleveur.getNbTomTomGPSModif() > 3) {
            return GPS_LOCKED;
        }
        return GPS_OK;
    }

    public static GPSStateEnum getGPSState(String key) {
        for (GPSStateEnum anEnum : GPSStateEnum.values()) {
            if (!anEnum.getKey().equals(key)) continue;
            return anEnum;
        }
        return null;
    }
}

