/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.entities;

import com.cybelia.sandra.entities.EtapeAbstract;
import com.cybelia.sandra.entities.LigneProduit;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class EtapeImpl
extends EtapeAbstract {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean isActif() {
        List<LigneProduit> produits = this.getProduits();
        return produits != null && !produits.isEmpty();
    }

    @Override
    public List<LigneProduit> getProduits() {
        List<LigneProduit> produits = super.getProduits();
        if (produits == null) {
            return null;
        }
        ArrayList actifProduits = Lists.newArrayList();
        for (LigneProduit produit : produits) {
            if (!produit.isActif()) continue;
            actifProduits.add(produit);
        }
        return actifProduits;
    }

    @Override
    public int sizeProduits() {
        List<LigneProduit> produitList = this.getProduits();
        if (produitList == null) {
            return 0;
        }
        return produitList.size();
    }
}

