/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.entities;

import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.Etape;
import com.cybelia.sandra.entities.LigneProduit;
import com.cybelia.sandra.entities.Tour;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class EtapeAbstract
extends TopiaEntityAbstract
implements Etape {
    protected int ordre;
    protected String commentaire;
    protected int etat;
    protected Tour tour;
    protected Eleveur eleveur;
    protected List<LigneProduit> produits;
    private static final long serialVersionUID = 7293127908543444579L;

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "ordre", Integer.TYPE, (Object)this.ordre);
        visitor.visit((TopiaEntity)this, "commentaire", String.class, (Object)this.commentaire);
        visitor.visit((TopiaEntity)this, "etat", Integer.TYPE, (Object)this.etat);
        visitor.visit((TopiaEntity)this, "tour", Tour.class, (Object)this.tour);
        visitor.visit((TopiaEntity)this, "eleveur", Eleveur.class, (Object)this.eleveur);
        visitor.visit((TopiaEntity)this, "produits", List.class, LigneProduit.class, this.produits);
        visitor.end((TopiaEntity)this);
    }

    @Override
    public void setOrdre(int ordre) {
        int oldValue = this.ordre;
        this.fireOnPreWrite("ordre", oldValue, ordre);
        this.ordre = ordre;
        this.fireOnPostWrite("ordre", oldValue, ordre);
    }

    @Override
    public int getOrdre() {
        this.fireOnPreRead("ordre", this.ordre);
        int result = this.ordre;
        this.fireOnPostRead("ordre", this.ordre);
        return result;
    }

    @Override
    public void setCommentaire(String commentaire) {
        String oldValue = this.commentaire;
        this.fireOnPreWrite("commentaire", oldValue, commentaire);
        this.commentaire = commentaire;
        this.fireOnPostWrite("commentaire", oldValue, commentaire);
    }

    @Override
    public String getCommentaire() {
        this.fireOnPreRead("commentaire", this.commentaire);
        String result = this.commentaire;
        this.fireOnPostRead("commentaire", this.commentaire);
        return result;
    }

    @Override
    public void setEtat(int etat) {
        int oldValue = this.etat;
        this.fireOnPreWrite("etat", oldValue, etat);
        this.etat = etat;
        this.fireOnPostWrite("etat", oldValue, etat);
    }

    @Override
    public int getEtat() {
        this.fireOnPreRead("etat", this.etat);
        int result = this.etat;
        this.fireOnPostRead("etat", this.etat);
        return result;
    }

    @Override
    public void setTour(Tour tour) {
        Tour oldValue = this.tour;
        this.fireOnPreWrite("tour", oldValue, tour);
        this.tour = tour;
        this.fireOnPostWrite("tour", oldValue, tour);
    }

    @Override
    public Tour getTour() {
        this.fireOnPreRead("tour", this.tour);
        Tour result = this.tour;
        this.fireOnPostRead("tour", this.tour);
        return result;
    }

    @Override
    public void setEleveur(Eleveur eleveur) {
        Eleveur oldValue = this.eleveur;
        this.fireOnPreWrite("eleveur", oldValue, eleveur);
        this.eleveur = eleveur;
        this.fireOnPostWrite("eleveur", oldValue, eleveur);
    }

    @Override
    public Eleveur getEleveur() {
        this.fireOnPreRead("eleveur", this.eleveur);
        Eleveur result = this.eleveur;
        this.fireOnPostRead("eleveur", this.eleveur);
        return result;
    }

    @Override
    public void addProduits(LigneProduit produits) {
        this.fireOnPreWrite("produits", null, produits);
        if (this.produits == null) {
            this.produits = new ArrayList<LigneProduit>();
        }
        produits.setEtape(this);
        this.produits.add(produits);
        this.fireOnPostWrite("produits", this.produits.size(), null, produits);
    }

    @Override
    public void addAllProduits(List<LigneProduit> produits) {
        if (produits == null) {
            return;
        }
        for (LigneProduit item : produits) {
            this.addProduits(item);
        }
    }

    @Override
    public void setProduits(List<LigneProduit> produits) {
        ArrayList<LigneProduit> oldValue = this.produits != null ? new ArrayList<LigneProduit>(this.produits) : null;
        this.fireOnPreWrite("produits", oldValue, produits);
        this.produits = produits;
        this.fireOnPostWrite("produits", oldValue, produits);
    }

    @Override
    public void removeProduits(LigneProduit produits) {
        this.fireOnPreWrite("produits", produits, null);
        if (this.produits == null || !this.produits.remove(produits)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        produits.setEtape(null);
        this.fireOnPostWrite("produits", this.produits.size() + 1, produits, null);
    }

    @Override
    public void clearProduits() {
        if (this.produits == null) {
            return;
        }
        for (LigneProduit item : this.produits) {
            item.setEtape(null);
        }
        ArrayList<LigneProduit> oldValue = new ArrayList<LigneProduit>(this.produits);
        this.fireOnPreWrite("produits", oldValue, this.produits);
        this.produits.clear();
        this.fireOnPostWrite("produits", oldValue, this.produits);
    }

    @Override
    public List<LigneProduit> getProduits() {
        return this.produits;
    }

    @Override
    public LigneProduit getProduitsByTopiaId(String topiaId) {
        return (LigneProduit)TopiaEntityHelper.getEntityByTopiaId(this.produits, (String)topiaId);
    }

    @Override
    public int sizeProduits() {
        if (this.produits == null) {
            return 0;
        }
        return this.produits.size();
    }

    @Override
    public boolean isProduitsEmpty() {
        int size = this.sizeProduits();
        return size == 0;
    }

    public List<TopiaEntity> getAggregate() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList<LigneProduit> tmp = new ArrayList<LigneProduit>();
        if (this.getProduits() != null) {
            tmp.addAll(this.getProduits());
        }
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity topiaEntity : tmp) {
            if (topiaEntity == null) continue;
            result.add(topiaEntity);
            result.addAll(topiaEntity.getComposite());
        }
        return result;
    }

    public String toString() {
        String result = new ToStringBuilder((Object)this).append("ordre", this.ordre).append("commentaire", (Object)this.commentaire).append("etat", this.etat).append("eleveur", (Object)this.eleveur).toString();
        return result;
    }
}

