/*
 * Decompiled with CFR 0.152.
 */
package org.postgis;

import java.sql.SQLException;
import org.postgis.Point;
import org.postgis.PointComposedGeom;

public class LineString
extends PointComposedGeom {
    private static final long serialVersionUID = 256L;
    double len = -1.0;

    public LineString() {
        super(2);
    }

    public LineString(Point[] pointArray) {
        super(2, pointArray);
    }

    public LineString(String string) throws SQLException {
        super(2, string);
    }

    public LineString(String string, boolean bl) throws SQLException {
        super(2, string, bl);
    }

    public LineString reverse() {
        Point[] pointArray = this.getPoints();
        int n = pointArray.length;
        Point[] pointArray2 = new Point[n];
        int n2 = 0;
        int n3 = n - 1;
        while (n2 < n) {
            pointArray2[n2] = pointArray[n3];
            ++n2;
            --n3;
        }
        return new LineString(pointArray2);
    }

    public LineString concat(LineString lineString) {
        int n;
        Point[] pointArray = this.getPoints();
        Point[] pointArray2 = lineString.getPoints();
        boolean bl = this.getLastPoint() == null || this.getLastPoint().equals(lineString.getFirstPoint());
        int n2 = pointArray.length + pointArray.length - (bl ? 1 : 0);
        Point[] pointArray3 = new Point[n2];
        for (n = 0; n < pointArray.length; ++n) {
            pointArray3[n] = pointArray[n];
        }
        if (!bl) {
            pointArray3[n++] = lineString.getFirstPoint();
        }
        int n3 = 1;
        while (n3 < pointArray2.length) {
            pointArray3[n] = pointArray2[n3];
            ++n3;
            ++n;
        }
        return new LineString(pointArray3);
    }

    public double length() {
        if (this.len < 0.0) {
            Point[] pointArray = this.getPoints();
            if (pointArray == null || pointArray.length < 2) {
                this.len = 0.0;
            } else {
                double d = 0.0;
                for (int i = 1; i < pointArray.length; ++i) {
                    d += pointArray[i - 1].distance(pointArray[i]);
                }
                this.len = d;
            }
        }
        return this.len;
    }
}

