/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.notifier;

import com.cybelia.sandra.SandraSchedulerConfigHelper;
import com.cybelia.sandra.notifier.SandraNotifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class ThreadNotifyCron
extends Thread {
    protected static final Log log = LogFactory.getLog(ThreadNotifyCron.class);
    protected String cronTopiaId;
    protected TopiaContext transaction;
    protected SandraNotifier sandraNotifier;

    public ThreadNotifyCron(SandraNotifier sandraNotifier, String cronTopiaId) {
        this.cronTopiaId = cronTopiaId;
        this.sandraNotifier = sandraNotifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting thread " + this.getName()));
        }
        TopiaContext transaction = null;
        try {
            TopiaContext ibuRootContext = SandraSchedulerConfigHelper.getSchedulerRootContext();
            transaction = ibuRootContext.beginTransaction();
            this.sandraNotifier.doNotifyCron(transaction, this.cronTopiaId);
        }
        catch (Exception eee) {
            log.error((Object)"Error notify cron", (Throwable)eee);
        }
        finally {
            if (transaction != null) {
                try {
                    if (!transaction.isClosed()) {
                        transaction.commitTransaction();
                        transaction.closeContext();
                    }
                }
                catch (TopiaException eee) {
                    log.error((Object)"Failed closing connection : ", (Throwable)eee);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Stopping thread " + this.getName()));
            }
        }
    }
}

