/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.entities.Commande;
import com.cybelia.sandra.entities.LigneProduit;
import com.cybelia.sandra.entities.LigneProduitDAO;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;

public class InjectorLigneProduit
implements Injector {
    private final Log log = LogFactory.getLog(InjectorLigneProduit.class);
    protected LigneProduit ligneProduit;

    @Override
    public LigneProduit getObject() {
        return this.ligneProduit;
    }

    @Override
    public void clear() {
        this.ligneProduit = null;
    }

    @Override
    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
        LigneProduitDAO ligneProduitDAO = SandraDAOHelper.getLigneProduitDAO(manager.getTransaction());
        Commande commande = manager.getCommande();
        this.ligneProduit = ligneProduitDAO.findByNaturalId(ibu.getProduitOrdre(), commande);
        if (this.ligneProduit == null) {
            this.ligneProduit = ligneProduitDAO.createByNaturalId(ibu.getProduitOrdre(), commande);
        }
        this.ligneProduit.setCode(ibu.getProduitCode());
        this.ligneProduit.setLibelle(ibu.getProduitLibelle());
        this.ligneProduit.setPresentation(ibu.getProduitPresentation());
        this.ligneProduit.setConditionnement(ibu.getProduitConditionnement());
        this.ligneProduit.setCapaciteUnitaire(ibu.getProduitCapaciteUnitaire());
        this.ligneProduit.setQuantiteACharger(ibu.getProduitQuantiteAChargee());
        this.ligneProduit.setMedicament(ibu.getProduitOrdonnance() != 0);
        this.ligneProduit.setCommentaire(ibu.getProduitCommentaire());
        this.ligneProduit.setSilo(manager.getSilo());
        this.ligneProduit.setUsine(manager.getUsine());
        this.ligneProduit.setQuantiteCommandee(ibu.getProduitQuantiteCommandee());
        this.ligneProduit.setAcces(ibu.getProduitAcces());
        this.ligneProduit.setEquipement(ibu.getProduitEquipement());
    }
}

