/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.Etape;
import com.cybelia.sandra.entities.EtapeDAO;
import com.cybelia.sandra.entities.LigneProduit;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.injector.InjectorTour;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import com.cybelia.sandra.ibu.manager.SynchNumberManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;

public class InjectorEtape
implements Injector {
    private final Log log = LogFactory.getLog(InjectorEtape.class);
    protected Etape etape;

    @Override
    public Etape getObject() {
        return this.etape;
    }

    @Override
    public void clear() {
        this.etape = null;
    }

    @Override
    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
        EtapeDAO etapeDAO = SandraDAOHelper.getEtapeDAO(manager.getTransaction());
        Eleveur eleveur = manager.getEleveur();
        Tour tour = manager.getTour();
        this.etape = etapeDAO.findByNaturalId(ibu.getProduitOrdreChargement(), tour, eleveur);
        boolean created = false;
        if (this.etape == null) {
            this.etape = etapeDAO.createByNaturalId(ibu.getProduitOrdreChargement(), tour, eleveur);
            tour.addEtapes(this.etape);
            InjectorTour.deleteSuiviTour(this.log, manager, tour);
            created = true;
            this.log.info((Object)("Creating etape [" + this.etape.getTopiaId() + "]"));
        } else {
            this.log.info((Object)("etape [" + this.etape.getTopiaId() + "]"));
        }
        this.etape.setEtat(ibu.getCommandeLigneEtat());
        this.etape.setCommentaire(ibu.getEleveurCommentaire());
        LigneProduit ligneProduit = manager.getLigneProduit();
        Etape oldEtape = ligneProduit.getEtape();
        ligneProduit.setEtape(this.etape);
        this.etape.addProduits(ligneProduit);
        if (created || oldEtape == null || !oldEtape.getTopiaId().equals(this.etape.getTopiaId())) {
            InjectorTour.deleteSuiviTour(this.log, manager, tour);
            String msg = "etape " + this.etape.getTopiaId() + " created";
            if (!created) {
                String topiaId = null;
                if (oldEtape != null) {
                    topiaId = oldEtape.getTopiaId();
                }
                msg = "etape changed old[" + topiaId + "] new[" + this.etape.getTopiaId() + "]";
            }
            SynchNumberManager.notifyTourChange(manager, tour, tour.getCamion().getTopiaId(), msg);
        }
    }
}

