/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.entities.EleveurDAO;
import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.entities.SocieteDAO;
import com.cybelia.sandra.entities.sig.PointGPS;
import com.cybelia.sandra.entities.sig.PointGPSDAO;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.csv.bean.IbuEleveurGPS;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;

public class InjectorEleveurGPS
implements Injector {
    protected static final Log log = LogFactory.getLog(InjectorEleveurGPS.class);
    protected Point gps;

    public Point getObject() {
        return this.gps;
    }

    @Override
    public void clear() {
        this.gps = null;
    }

    @Override
    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
    }

    public void inject(ManagerInjector manager, IbuEleveurGPS ibu) throws TopiaException {
        SocieteDAO societeDAO = SandraDAOHelper.getSocieteDAO(manager.getTransaction());
        Object societe = societeDAO.findByNaturalId(ibu.getCodeSociete());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found societe : " + societe));
        }
        if (societe != null) {
            EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO(manager.getTransaction());
            Object eleveur = eleveurDAO.findByNaturalId((Societe)societe, ibu.getCodeEleveur());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found eleveur : " + eleveur));
            }
            if (eleveur != null) {
                PointGPS tomtomGPS = eleveur.getTomtomGPS();
                if (tomtomGPS != null) {
                    this.gps = tomtomGPS.getPoint();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found gps : " + this.gps));
                }
                if (this.gps == null) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Creating gps for eleveur '" + ibu.getCodeSociete() + "-" + ibu.getCodeEleveur() + "' with coord : x:" + ibu.getX() + " y:" + ibu.getY()));
                    }
                    GeometryFactory geometryFactory = new GeometryFactory();
                    Coordinate coordinate = new Coordinate(this.safeParseDouble(ibu.getX()).doubleValue(), this.safeParseDouble(ibu.getY()).doubleValue());
                    this.gps = geometryFactory.createPoint(coordinate);
                    PointGPSDAO pointGPSDAO = SandraDAOHelper.getPointGPSDAO(manager.getTransaction());
                    PointGPS pointGPS = (PointGPS)pointGPSDAO.create(new Object[]{"point", this.gps});
                    eleveur.setTomtomGPS(pointGPS);
                    eleveurDAO.update((TopiaEntity)eleveur);
                }
            }
        }
    }

    protected Double safeParseDouble(String toParse) {
        if (toParse == null) {
            return null;
        }
        toParse = toParse.replace(',', '.');
        return Double.parseDouble(toParse);
    }
}

