/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.ibu;

import java.io.File;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IbuFileComparator
implements Comparator<File> {
    protected Pattern ibuFilePattern;

    public IbuFileComparator(String ibuPatternFile) {
        this.ibuFilePattern = Pattern.compile(ibuPatternFile);
    }

    @Override
    public int compare(File o1, File o2) {
        String name1 = o1.getName();
        String name2 = o2.getName();
        Matcher matcher1 = this.ibuFilePattern.matcher(name1);
        Matcher matcher2 = this.ibuFilePattern.matcher(name2);
        if (!matcher1.matches()) {
            return -1;
        }
        if (!matcher2.matches()) {
            return 1;
        }
        String date1 = matcher1.group(1);
        String date2 = matcher2.group(1);
        return date1.compareTo(date2);
    }
}

