/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.readers;

import com.vividsolutions.jts.geom.Geometry;
import org.hibernate.Criteria;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.metadata.ClassMetadata;
import org.hibernatespatial.criterion.SpatialFilter;
import org.hibernatespatial.criterion.SpatialRestrictions;
import org.hibernatespatial.helper.FinderException;
import org.hibernatespatial.helper.GeometryPropertyFinder;
import org.hibernatespatial.readers.Feature;
import org.hibernatespatial.readers.FeatureAdapter;
import org.hibernatespatial.readers.FeatureReader;

public class BasicFeatureReader
implements FeatureReader {
    private StatelessSession session = null;
    private ScrollableResults results = null;
    private final ClassMetadata metadata;
    private final Transaction tx;
    private final int fetchSize = 1024;

    public BasicFeatureReader(Class entityClass, SessionFactory sf, Geometry filterGeom, String attributeFilter) throws FinderException {
        this.session = sf.openStatelessSession();
        this.metadata = sf.getClassMetadata(entityClass);
        GeometryPropertyFinder gp = new GeometryPropertyFinder();
        String geomProp = gp.find(this.metadata);
        Criteria crit = this.session.createCriteria(entityClass);
        if (filterGeom != null) {
            SpatialFilter filter = SpatialRestrictions.filter(geomProp, filterGeom);
            crit.add((Criterion)filter);
        }
        if (attributeFilter != null) {
            crit.add(Restrictions.sqlRestriction((String)attributeFilter));
        }
        crit.setFetchSize(1024);
        this.tx = this.session.beginTransaction();
        this.results = crit.scroll(ScrollMode.FORWARD_ONLY);
    }

    public void close() {
        this.tx.commit();
        this.results.close();
        this.results = null;
        this.session.close();
    }

    public boolean hasNext() {
        return this.results.next();
    }

    public Feature next() {
        Object[] currentRow = this.results.get();
        if (currentRow == null) {
            this.close();
            throw new RuntimeException("Reading beyond the Scrollable Results.");
        }
        Object f = currentRow[0];
        return FeatureAdapter.adapt(f, this.metadata);
    }
}

