/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.pojo;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.hibernatespatial.HBSpatialExtension;
import org.hibernatespatial.pojo.ClassInfo;
import org.hibernatespatial.pojo.FeatureClassGenerator;
import org.hibernatespatial.pojo.FeatureMapper;
import org.hibernatespatial.pojo.MappingsGenerator;
import org.hibernatespatial.pojo.PKeyNotFoundException;
import org.hibernatespatial.pojo.SimpleNamingStrategy;
import org.hibernatespatial.pojo.TableNotFoundException;
import org.hibernatespatial.pojo.TypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoMapper {
    protected static final Logger logger = LoggerFactory.getLogger(AutoMapper.class);
    protected static final String PACKAGE_NAME = "org.hibernatespatial.features.generated";
    private static Map<TableName, Class<?>> tableClassMap = new HashMap();

    public static synchronized Document map(Connection conn, String catalog, String schema, Collection<String> tableNames) throws SQLException {
        SimpleNamingStrategy naming = new SimpleNamingStrategy();
        TypeMapper typeMapper = new TypeMapper(HBSpatialExtension.getDefaultSpatialDialect().getDbGeometryTypeName());
        DatabaseMetaData dmd = conn.getMetaData();
        FeatureMapper fMapper = new FeatureMapper(naming, typeMapper);
        FeatureClassGenerator fGenerator = new FeatureClassGenerator(PACKAGE_NAME, naming);
        ArrayList<ClassInfo> cInfos = new ArrayList<ClassInfo>();
        for (String tableName : tableNames) {
            logger.info("Generating class info for table " + tableName + " in catalog/schema " + catalog + "/" + schema);
            try {
                ClassInfo cInfo = fMapper.createClassInfo(catalog, schema, tableName, dmd);
                logger.info("Generating class " + cInfo.getClassName() + " for table " + tableName);
                Class<?> clazz = fGenerator.generate(cInfo);
                tableClassMap.put(new TableName(catalog, schema, tableName), clazz);
                cInfos.add(cInfo);
            }
            catch (TableNotFoundException e) {
                logger.warn(e.getMessage());
            }
        }
        logger.info("Generating Hibernate Mapping file");
        MappingsGenerator mappingGenerator = new MappingsGenerator(PACKAGE_NAME);
        try {
            mappingGenerator.load(cInfos);
        }
        catch (PKeyNotFoundException e) {
            throw new RuntimeException(e);
        }
        return mappingGenerator.getMappingsDoc();
    }

    public static Class<?> getClass(String catalog, String schema, String tableName) {
        TableName tbn = new TableName(catalog, schema, tableName);
        return tableClassMap.get(tbn);
    }

    public static List<String[]> getMappedTables() {
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (TableName tbn : tableClassMap.keySet()) {
            String[] sa = new String[]{tbn.catalog, tbn.schema, tbn.tableName};
            list.add(sa);
        }
        return list;
    }

    private static class TableName {
        String catalog;
        String schema;
        String tableName;

        private TableName(String catalog, String schema, String tableName) {
            this.catalog = catalog;
            this.schema = schema;
            this.tableName = tableName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.catalog == null ? 0 : this.catalog.hashCode());
            result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
            result = 31 * result + (this.tableName == null ? 0 : this.tableName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TableName)) {
                return false;
            }
            TableName other = (TableName)obj;
            if (this.catalog == null ? other.catalog != null : !this.catalog.equals(other.catalog)) {
                return false;
            }
            if (this.schema == null ? other.schema != null : !this.schema.equals(other.schema)) {
                return false;
            }
            return !(this.tableName == null ? other.tableName != null : !this.tableName.equals(other.tableName));
        }
    }
}

