/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.criterion;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import org.hibernate.criterion.Criterion;
import org.hibernatespatial.criterion.SpatialFilter;
import org.hibernatespatial.criterion.SpatialRelateExpression;

public class SpatialRestrictions {
    SpatialRestrictions() {
    }

    public static SpatialRelateExpression eq(String propertyName, Geometry value) {
        return new SpatialRelateExpression(propertyName, value, value, 0);
    }

    public static SpatialRelateExpression within(String propertyName, Geometry value) {
        return new SpatialRelateExpression(propertyName, value, value, 4);
    }

    public static SpatialRelateExpression contains(String propertyName, Geometry value) {
        return new SpatialRelateExpression(propertyName, value, value, 6);
    }

    public static SpatialRelateExpression crosses(String propertyName, Geometry value) {
        return new SpatialRelateExpression(propertyName, value, value, 3);
    }

    public static SpatialRelateExpression disjoint(String propertyName, Geometry value) {
        return new SpatialRelateExpression(propertyName, null, value, 1);
    }

    public static SpatialRelateExpression intersects(String propertyName, Geometry value) {
        return new SpatialRelateExpression(propertyName, value, value, 7);
    }

    public static SpatialRelateExpression overlaps(String propertyName, Geometry value) {
        return new SpatialRelateExpression(propertyName, value, value, 5);
    }

    public static SpatialRelateExpression touches(String propertyName, Geometry value) {
        return new SpatialRelateExpression(propertyName, value, value, 2);
    }

    public static SpatialFilter filter(String propertyName, Geometry filter) {
        return new SpatialFilter(propertyName, filter);
    }

    public static SpatialFilter filter(String propertyName, Envelope envelope, int SRID) {
        return new SpatialFilter(propertyName, envelope, SRID);
    }

    public static Criterion spatialRestriction(int relation, String propertyName, Geometry value) {
        switch (relation) {
            case 6: {
                return SpatialRestrictions.contains(propertyName, value);
            }
            case 3: {
                return SpatialRestrictions.crosses(propertyName, value);
            }
            case 1: {
                return SpatialRestrictions.disjoint(propertyName, value);
            }
            case 7: {
                return SpatialRestrictions.intersects(propertyName, value);
            }
            case 0: {
                return SpatialRestrictions.eq(propertyName, value);
            }
            case 8: {
                return SpatialRestrictions.filter(propertyName, value);
            }
            case 5: {
                return SpatialRestrictions.overlaps(propertyName, value);
            }
            case 2: {
                return SpatialRestrictions.touches(propertyName, value);
            }
            case 4: {
                return SpatialRestrictions.within(propertyName, value);
            }
        }
        throw new IllegalArgumentException("Non-existant spatial relation passed.");
    }
}

