package com.franciaflex.faxtomail.services.service.imports;

/*
 * #%L
 * FaxToMail :: Service
 * $Id: ArchiveImportModel.java 662 2014-10-03 09:14:56Z kmorin $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-1.0/faxtomail-service/src/main/java/com/franciaflex/faxtomail/services/service/imports/ArchiveImportModel.java $
 * %%
 * Copyright (C) 2014 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

import org.nuiton.csv.Common;
import org.nuiton.csv.ValueParser;
import org.nuiton.csv.ext.AbstractImportModel;

import com.franciaflex.faxtomail.persistence.entities.DemandType;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.WaitingState;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.persistence.entities.Priority;

/**
 * Modele d'import des archives, défini comme suit:
 * 
 * receptionDate;projectReference;sender;fax;recipient;object;archiveDate;companyReference;
 * originalEmail;comment;etatAttente;demandType;priority;mailFolder;client-code;client-brand;attachments
 * 
 * @author Eric Chatellier
 */
public class ArchiveImportModel extends AbstractImportModel<ArchiveImportBean> {

    /**
     * Parse date pattern : dd/MM/yyyy hh:mm:ss.
     */
    protected ValueParser<Date> dateValueParser = new ValueParser<Date>() {
        protected DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
        @Override
        public Date parse(String value) throws ParseException {
            return dateFormat.parse(value);
        }
    };

    /**
     * Parser for boolean fields.
     */
    protected ValueParser<Boolean> yesNoParser = new ValueParser<Boolean>() {
        @Override
        public Boolean parse(String value) throws ParseException {
            return "oui".equalsIgnoreCase(value);
        }
    };

    public ArchiveImportModel(char separator,
            final Map<String, WaitingState> waitingStates, final Map<String, DemandType> demandTypes,
            final Map<String, Priority> priorities, final Map<String, MailFolder> mailFolderMap) {
        super(separator);

        newMandatoryColumn("receptionDate", Email.PROPERTY_RECEPTION_DATE, dateValueParser);
        newMandatoryColumn("projectReference", Email.PROPERTY_PROJECT_REFERENCE);
        newMandatoryColumn("sender", Email.PROPERTY_SENDER, new ValueParser<Object>() {
            @Override
            public Object parse(String value) throws ParseException {
                value = value.replaceFirst("^.*<(.*)>$", "$1");
                value = value.toLowerCase();
                return value;
            }
        });
        newMandatoryColumn("fax", Email.PROPERTY_FAX, Common.PRIMITIVE_BOOLEAN);
        newMandatoryColumn("recipient", Email.PROPERTY_RECIPIENT);
        newMandatoryColumn("object", Email.PROPERTY_OBJECT);
        newMandatoryColumn("archiveDate", Email.PROPERTY_ARCHIVE_DATE, dateValueParser);
        newMandatoryColumn("companyReference", Email.PROPERTY_COMPANY_REFERENCE);
        newMandatoryColumn("originalEmail", Email.PROPERTY_ORIGINAL_EMAIL);
        newMandatoryColumn("comment", Email.PROPERTY_COMMENT);
        newMandatoryColumn("etatAttente", Email.PROPERTY_WAITING_STATE, new ValueParser<WaitingState>() {
            @Override
            public WaitingState parse(String value) throws ParseException {
                return waitingStates.get(value);
            }
        });
        newMandatoryColumn("demandType", Email.PROPERTY_DEMAND_TYPE, new ValueParser<DemandType>() {
            @Override
            public DemandType parse(String value) throws ParseException {
                return demandTypes.get(value);
            }
        });
        newMandatoryColumn("priority", Email.PROPERTY_PRIORITY, new ValueParser<Priority>() {
            @Override
            public Priority parse(String value) throws ParseException {
                return priorities.get(value);
            }
        });
        newMandatoryColumn("mailFolder", Email.PROPERTY_MAIL_FOLDER, new ValueParser<MailFolder>() {
            @Override
            public MailFolder parse(String value) throws ParseException {
                return mailFolderMap.get(value);
            }
        });
        newMandatoryColumn("client-code", ArchiveImportBean.PROPERTY_CLIENT_CODE);
        newMandatoryColumn("client-brand", ArchiveImportBean.PROPERTY_CLIENT_BRAND);
        newMandatoryColumn("attachments", ArchiveImportBean.PROPERTY_ATTACHMENT_PATHS);
    }

    @Override
    public ArchiveImportBean newEmptyInstance() {
        return new ArchiveImportBean();
    }
}
