/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class MapEntryRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`MapEntryRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with `Map.Entry` instances.\n[Source](https://error-prone.picnic.tech/refasterrules/MapEntryRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new MapEntryRecipe(), new MapEntryComparingByKeyRecipe(), new MapEntryComparingByKeyWithCustomComparatorRecipe(), new MapEntryComparingByValueRecipe(), new MapEntryComparingByValueWithCustomComparatorRecipe()});
    }

    @NullMarked
    public static class MapEntryRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Map#entry(Object, Object)` over alternative ways to create an immutable map entry";
        }

        public String getDescription() {
            return "<strong>Warning:</strong> while both `Maps#immutableEntry(Object, Object)` and `AbstractMap.SimpleImmutableEntry` allow `null` keys and values, the preferred @link\n Map#entry(Object, Object)} variant does not. Moreover, the `Map.Entry` instances produced\n by the former approaches is `java.io.Serializable`, while this does not hold for the\n object returned by the preferred approach.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"com.google.common.collect.Maps.immutableEntry(#{key:any(K)}, #{value:any(V)})").bindType("java.util.Map.Entry<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.Maps");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Map.entry(#{key:any(K)}, #{value:any(V)})").bindType("java.util.Map.Entry<K, V>").genericTypes(new String[]{"K", "V"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"new java.util.AbstractMap.SimpleImmutableEntry<>(#{key:any(K)}, #{value:any(V)})").bindType("java.util.Map.Entry<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Map.entry(#{key:any(K)}, #{value:any(V)})").bindType("java.util.Map.Entry<K, V>").genericTypes(new String[]{"K", "V"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }

                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"com.google.common.collect.Maps.immutableEntry(#{key:any(K)}, #{value:any(V)})").bindType("java.util.Map.Entry<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.Maps");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Map.entry(#{key:any(K)}, #{value:any(V)})").bindType("java.util.Map.Entry<K, V>").genericTypes(new String[]{"K", "V"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"new java.util.AbstractMap.SimpleImmutableEntry<>(#{key:any(K)}, #{value:any(V)})").bindType("java.util.Map.Entry<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Map.entry(#{key:any(K)}, #{value:any(V)})").bindType("java.util.Map.Entry<K, V>").genericTypes(new String[]{"K", "V"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitNewClass(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.AbstractMap.SimpleImmutableEntry <init>(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Maps", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Maps immutableEntry(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MapEntryComparingByKeyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `MapEntryRules.MapEntryComparingByKey`";
        }

        public String getDescription() {
            return "Prefer `Map.Entry#comparingByKey()` over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"java.util.Comparator.comparing(java.util.Map.Entry::getKey)").bindType("java.util.Comparator<java.util.Map.Entry<K, V>>").genericTypes(new String[]{"K extends java.lang.Comparable<? super K>", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Comparator");
                        this.maybeRemoveImport("java.util.Comparator.comparing");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Map.Entry.comparingByKey()").bindType("java.util.Comparator<java.util.Map.Entry<K, V>>").genericTypes(new String[]{"K extends java.lang.Comparable<? super K>", "V"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.util.Map.Entry.comparingByKey(java.util.Comparator.naturalOrder())").bindType("java.util.Comparator<java.util.Map.Entry<K, V>>").genericTypes(new String[]{"K extends java.lang.Comparable<? super K>", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Comparator");
                        this.maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Map.Entry.comparingByKey()").bindType("java.util.Comparator<java.util.Map.Entry<K, V>>").genericTypes(new String[]{"K extends java.lang.Comparable<? super K>", "V"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Comparator comparing(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Comparator naturalOrder(..)", true), new UsesMethod("java.util.Map.Entry comparingByKey(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MapEntryComparingByKeyWithCustomComparatorRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `MapEntryRules.MapEntryComparingByKeyWithCustomComparator`";
        }

        public String getDescription() {
            return "Prefer `Map.Entry#comparingByKey(Comparator)` over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.util.Comparator.comparing(java.util.Map.Entry::getKey, #{cmp:any(java.util.Comparator<? super K>)})").bindType("java.util.Comparator<java.util.Map.Entry<K, V>>").genericTypes(new String[]{"K", "V"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Comparator");
                        this.maybeRemoveImport("java.util.Comparator.comparing");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Map.Entry.comparingByKey(#{cmp:any(java.util.Comparator<? super K>)})").bindType("java.util.Comparator<java.util.Map.Entry<K, V>>").genericTypes(new String[]{"K", "V"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesMethod("java.util.Comparator comparing(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MapEntryComparingByValueRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `MapEntryRules.MapEntryComparingByValue`";
        }

        public String getDescription() {
            return "Prefer `Map.Entry#comparingByValue()` over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"java.util.Comparator.comparing(java.util.Map.Entry::getValue)").bindType("java.util.Comparator<java.util.Map.Entry<K, V>>").genericTypes(new String[]{"K", "V extends java.lang.Comparable<? super V>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Comparator");
                        this.maybeRemoveImport("java.util.Comparator.comparing");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Map.Entry.comparingByValue()").bindType("java.util.Comparator<java.util.Map.Entry<K, V>>").genericTypes(new String[]{"K", "V extends java.lang.Comparable<? super V>"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.util.Map.Entry.comparingByValue(java.util.Comparator.naturalOrder())").bindType("java.util.Comparator<java.util.Map.Entry<K, V>>").genericTypes(new String[]{"K", "V extends java.lang.Comparable<? super V>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Comparator");
                        this.maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Map.Entry.comparingByValue()").bindType("java.util.Comparator<java.util.Map.Entry<K, V>>").genericTypes(new String[]{"K", "V extends java.lang.Comparable<? super V>"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Comparator comparing(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Comparator naturalOrder(..)", true), new UsesMethod("java.util.Map.Entry comparingByValue(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MapEntryComparingByValueWithCustomComparatorRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `MapEntryRules.MapEntryComparingByValueWithCustomComparator`";
        }

        public String getDescription() {
            return "Prefer `Map.Entry#comparingByValue(Comparator)` over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.util.Comparator.comparing(java.util.Map.Entry::getValue, #{cmp:any(java.util.Comparator<? super V>)})").bindType("java.util.Comparator<java.util.Map.Entry<K, V>>").genericTypes(new String[]{"K", "V"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Comparator");
                        this.maybeRemoveImport("java.util.Comparator.comparing");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Map.Entry.comparingByValue(#{cmp:any(java.util.Comparator<? super V>)})").bindType("java.util.Comparator<java.util.Map.Entry<K, V>>").genericTypes(new String[]{"K", "V"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesMethod("java.util.Comparator comparing(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

