/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class ReactorRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`ReactorRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to Reactor expressions and statements [Source](https://error-prone.picnic.tech/refasterrules/ReactorRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new StepVerifierVerifyRecipe(), new StepVerifierVerifyDurationRecipe(), new StepVerifierVerifyLaterRecipe(), new StepVerifierLastStepVerifyCompleteRecipe(), new StepVerifierLastStepVerifyErrorRecipe(), new StepVerifierLastStepVerifyErrorMatchesRecipe(), new StepVerifierLastStepVerifyErrorSatisfiesRecipe(), new StepVerifierLastStepVerifyErrorMessageRecipe(), new StepVerifierLastStepVerifyTimeoutRecipe()});
    }

    @NullMarked
    public static class StepVerifierVerifyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.StepVerifierVerify`";
        }

        public String getDescription() {
            return "Prefer `StepVerifier#verify()` over a dangling `StepVerifier#verifyThenAssertThat()`";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stepVerifier:any(reactor.test.StepVerifier)}.verifyThenAssertThat()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stepVerifier:any(reactor.test.StepVerifier)}.verify()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.test.StepVerifier", Boolean.valueOf(true)), new UsesMethod("reactor.test.StepVerifier verifyThenAssertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StepVerifierVerifyDurationRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.StepVerifierVerifyDuration`";
        }

        public String getDescription() {
            return "Prefer `StepVerifier#verify(Duration)` over a dangling `StepVerifier#verifyThenAssertThat(Duration)`";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stepVerifier:any(reactor.test.StepVerifier)}.verifyThenAssertThat(#{duration:any(java.time.Duration)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stepVerifier:any(reactor.test.StepVerifier)}.verify(#{duration:any(java.time.Duration)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesType("reactor.test.StepVerifier", Boolean.valueOf(true)), new UsesMethod("reactor.test.StepVerifier verifyThenAssertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StepVerifierVerifyLaterRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.StepVerifierVerifyLater`";
        }

        public String getDescription() {
            return "Don't unnecessarily invoke `StepVerifier#verifyLater()` multiple times";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stepVerifier:any(reactor.test.StepVerifier)}.verifyLater().verifyLater()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stepVerifier:any(reactor.test.StepVerifier)}.verifyLater()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.test.StepVerifier", Boolean.valueOf(true)), new UsesMethod("reactor.test.StepVerifier verifyLater(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StepVerifierLastStepVerifyCompleteRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.StepVerifierLastStepVerifyComplete`";
        }

        public String getDescription() {
            return "Prefer `StepVerifier.LastStep#verifyComplete()` over more verbose alternatives";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.expectComplete().verify()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.verifyComplete()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("reactor.test.StepVerifier verify(..)", true), new UsesMethod("reactor.test.StepVerifier.LastStep expectComplete(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StepVerifierLastStepVerifyErrorRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.StepVerifierLastStepVerifyError`";
        }

        public String getDescription() {
            return "Prefer `StepVerifier.LastStep#verifyError()` over more verbose alternatives";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.expectError().verify()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.verifyError()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("reactor.test.StepVerifier verify(..)", true), new UsesMethod("reactor.test.StepVerifier.LastStep expectError(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StepVerifierLastStepVerifyErrorMatchesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.StepVerifierLastStepVerifyErrorMatches`";
        }

        public String getDescription() {
            return "Prefer `StepVerifier.LastStep#verifyErrorMatches(Predicate)` over more verbose alternatives";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.expectErrorMatches(#{predicate:any(java.util.function.Predicate<java.lang.Throwable>)}).verify()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before2 = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.expectError().verifyThenAssertThat().hasOperatorErrorMatching(#{predicate:any(java.util.function.Predicate<java.lang.Throwable>)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.verifyErrorMatches(#{predicate:any(java.util.function.Predicate<java.lang.Throwable>)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Predicate", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.test.StepVerifier verifyThenAssertThat(..)", true), new UsesMethod("reactor.test.StepVerifier.Assertions hasOperatorErrorMatching(..)", true), new UsesMethod("reactor.test.StepVerifier.LastStep expectError(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("reactor.test.StepVerifier verify(..)", true), new UsesMethod("reactor.test.StepVerifier.LastStep expectErrorMatches(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StepVerifierLastStepVerifyErrorSatisfiesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.StepVerifierLastStepVerifyErrorSatisfies`";
        }

        public String getDescription() {
            return "Prefer `StepVerifier.LastStep#verifyErrorSatisfies(Consumer)` over more verbose alternatives";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.expectErrorSatisfies(#{consumer:any(java.util.function.Consumer<java.lang.Throwable>)}).verify()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.verifyErrorSatisfies(#{consumer:any(java.util.function.Consumer<java.lang.Throwable>)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesType("java.util.function.Consumer", Boolean.valueOf(true)), new UsesMethod("reactor.test.StepVerifier verify(..)", true), new UsesMethod("reactor.test.StepVerifier.LastStep expectErrorSatisfies(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StepVerifierLastStepVerifyErrorMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.StepVerifierLastStepVerifyErrorMessage`";
        }

        public String getDescription() {
            return "Prefer `StepVerifier.LastStep#verifyErrorMessage(String)` over more verbose alternatives";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.expectErrorMessage(#{message:any(java.lang.String)}).verify()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.verifyErrorMessage(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("reactor.test.StepVerifier verify(..)", true), new UsesMethod("reactor.test.StepVerifier.LastStep expectErrorMessage(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StepVerifierLastStepVerifyTimeoutRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.StepVerifierLastStepVerifyTimeout`";
        }

        public String getDescription() {
            return "Prefer `StepVerifier.LastStep#verifyTimeout(Duration)` over more verbose alternatives";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.expectTimeout(#{duration:any(java.time.Duration)}).verify()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.verifyTimeout(#{duration:any(java.time.Duration)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("reactor.test.StepVerifier verify(..)", true), new UsesMethod("reactor.test.StepVerifier.LastStep expectTimeout(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

