/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class NullRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`NullRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with (possibly) null values [Source](https://error-prone.picnic.tech/refasterrules/NullRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new IsNullRecipe(), new IsNotNullRecipe()});
    }

    @NullMarked
    public static class IsNullRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `NullRules.IsNull`";
        }

        public String getDescription() {
            return "Prefer the `==` operator (with `null` as the second operand) over `Objects#isNull(Object)`";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"null == #{object:any(java.lang.@org.jspecify.annotations.Nullable Object)}").build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"java.util.Objects.isNull(#{object:any(java.lang.@org.jspecify.annotations.Nullable Object)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{object:any(java.lang.@org.jspecify.annotations.Nullable Object)} == null").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.Objects");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
        }
    }

    @NullMarked
    public static class IsNotNullRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `NullRules.IsNotNull`";
        }

        public String getDescription() {
            return "Prefer the `!=` operator (with `null` as the second operand) over `Objects#nonNull(Object)`";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"null != #{object:any(java.lang.@org.jspecify.annotations.Nullable Object)}").build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"java.util.Objects.nonNull(#{object:any(java.lang.@org.jspecify.annotations.Nullable Object)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{object:any(java.lang.@org.jspecify.annotations.Nullable Object)} != null").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.Objects");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
        }
    }
}

