/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.transfer.s3.CompletedFileUpload;
import software.amazon.awssdk.transfer.s3.FileUpload;
import software.amazon.awssdk.transfer.s3.progress.TransferProgress;
import software.amazon.awssdk.utils.ToString;

@SdkInternalApi
public final class DefaultFileUpload
implements FileUpload {
    private final CompletableFuture<CompletedFileUpload> completionFuture;
    private final TransferProgress progress;

    DefaultFileUpload(CompletableFuture<CompletedFileUpload> completionFuture, TransferProgress progress) {
        this.completionFuture = completionFuture;
        this.progress = progress;
    }

    @Override
    public CompletableFuture<CompletedFileUpload> completionFuture() {
        return this.completionFuture;
    }

    @Override
    public TransferProgress progress() {
        return this.progress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultFileUpload that = (DefaultFileUpload)o;
        if (!Objects.equals(this.completionFuture, that.completionFuture)) {
            return false;
        }
        return Objects.equals(this.progress, that.progress);
    }

    public int hashCode() {
        int result = this.completionFuture != null ? this.completionFuture.hashCode() : 0;
        result = 31 * result + (this.progress != null ? this.progress.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToString.builder((String)"DefaultFileUpload").add("completionFuture", this.completionFuture).add("progress", (Object)this.progress).build();
    }
}

