/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An automated backup of a DB instance. It consists of system backups, transaction logs, and the database instance
 * properties that existed at the time you deleted the source instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DBInstanceAutomatedBackup implements SdkPojo, Serializable,
        ToCopyableBuilder<DBInstanceAutomatedBackup.Builder, DBInstanceAutomatedBackup> {
    private static final SdkField<String> DB_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceArn").getter(getter(DBInstanceAutomatedBackup::dbInstanceArn))
            .setter(setter(Builder::dbInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceArn").build()).build();

    private static final SdkField<String> DBI_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbiResourceId").getter(getter(DBInstanceAutomatedBackup::dbiResourceId))
            .setter(setter(Builder::dbiResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbiResourceId").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(DBInstanceAutomatedBackup::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceIdentifier").getter(getter(DBInstanceAutomatedBackup::dbInstanceIdentifier))
            .setter(setter(Builder::dbInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build())
            .build();

    private static final SdkField<RestoreWindow> RESTORE_WINDOW_FIELD = SdkField
            .<RestoreWindow> builder(MarshallingType.SDK_POJO).memberName("RestoreWindow")
            .getter(getter(DBInstanceAutomatedBackup::restoreWindow)).setter(setter(Builder::restoreWindow))
            .constructor(RestoreWindow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreWindow").build()).build();

    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AllocatedStorage").getter(getter(DBInstanceAutomatedBackup::allocatedStorage))
            .setter(setter(Builder::allocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DBInstanceAutomatedBackup::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(DBInstanceAutomatedBackup::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(DBInstanceAutomatedBackup::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(DBInstanceAutomatedBackup::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<Instant> INSTANCE_CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("InstanceCreateTime").getter(getter(DBInstanceAutomatedBackup::instanceCreateTime))
            .setter(setter(Builder::instanceCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCreateTime").build())
            .build();

    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUsername").getter(getter(DBInstanceAutomatedBackup::masterUsername))
            .setter(setter(Builder::masterUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(DBInstanceAutomatedBackup::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(DBInstanceAutomatedBackup::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseModel").getter(getter(DBInstanceAutomatedBackup::licenseModel))
            .setter(setter(Builder::licenseModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseModel").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Iops")
            .getter(getter(DBInstanceAutomatedBackup::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()).build();

    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptionGroupName").getter(getter(DBInstanceAutomatedBackup::optionGroupName))
            .setter(setter(Builder::optionGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()).build();

    private static final SdkField<String> TDE_CREDENTIAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TdeCredentialArn").getter(getter(DBInstanceAutomatedBackup::tdeCredentialArn))
            .setter(setter(Builder::tdeCredentialArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TdeCredentialArn").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypted").getter(getter(DBInstanceAutomatedBackup::encrypted)).setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()).build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageType").getter(getter(DBInstanceAutomatedBackup::storageType))
            .setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(DBInstanceAutomatedBackup::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Timezone").getter(getter(DBInstanceAutomatedBackup::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()).build();

    private static final SdkField<Boolean> IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IAMDatabaseAuthenticationEnabled")
            .getter(getter(DBInstanceAutomatedBackup::iamDatabaseAuthenticationEnabled))
            .setter(setter(Builder::iamDatabaseAuthenticationEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMDatabaseAuthenticationEnabled")
                    .build()).build();

    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BackupRetentionPeriod").getter(getter(DBInstanceAutomatedBackup::backupRetentionPeriod))
            .setter(setter(Builder::backupRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build())
            .build();

    private static final SdkField<String> DB_INSTANCE_AUTOMATED_BACKUPS_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceAutomatedBackupsArn")
            .getter(getter(DBInstanceAutomatedBackup::dbInstanceAutomatedBackupsArn))
            .setter(setter(Builder::dbInstanceAutomatedBackupsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceAutomatedBackupsArn")
                    .build()).build();

    private static final SdkField<List<DBInstanceAutomatedBackupsReplication>> DB_INSTANCE_AUTOMATED_BACKUPS_REPLICATIONS_FIELD = SdkField
            .<List<DBInstanceAutomatedBackupsReplication>> builder(MarshallingType.LIST)
            .memberName("DBInstanceAutomatedBackupsReplications")
            .getter(getter(DBInstanceAutomatedBackup::dbInstanceAutomatedBackupsReplications))
            .setter(setter(Builder::dbInstanceAutomatedBackupsReplications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DBInstanceAutomatedBackupsReplications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBInstanceAutomatedBackupsReplication")
                            .memberFieldInfo(
                                    SdkField.<DBInstanceAutomatedBackupsReplication> builder(MarshallingType.SDK_POJO)
                                            .constructor(DBInstanceAutomatedBackupsReplication::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBInstanceAutomatedBackupsReplication").build()).build())
                            .build()).build();

    private static final SdkField<String> BACKUP_TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupTarget").getter(getter(DBInstanceAutomatedBackup::backupTarget))
            .setter(setter(Builder::backupTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupTarget").build()).build();

    private static final SdkField<Integer> STORAGE_THROUGHPUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StorageThroughput").getter(getter(DBInstanceAutomatedBackup::storageThroughput))
            .setter(setter(Builder::storageThroughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageThroughput").build()).build();

    private static final SdkField<String> AWS_BACKUP_RECOVERY_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsBackupRecoveryPointArn").getter(getter(DBInstanceAutomatedBackup::awsBackupRecoveryPointArn))
            .setter(setter(Builder::awsBackupRecoveryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsBackupRecoveryPointArn").build())
            .build();

    private static final SdkField<Boolean> DEDICATED_LOG_VOLUME_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DedicatedLogVolume").getter(getter(DBInstanceAutomatedBackup::dedicatedLogVolume))
            .setter(setter(Builder::dedicatedLogVolume))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedLogVolume").build())
            .build();

    private static final SdkField<Boolean> MULTI_TENANT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiTenant").getter(getter(DBInstanceAutomatedBackup::multiTenant))
            .setter(setter(Builder::multiTenant))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiTenant").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_ARN_FIELD,
            DBI_RESOURCE_ID_FIELD, REGION_FIELD, DB_INSTANCE_IDENTIFIER_FIELD, RESTORE_WINDOW_FIELD, ALLOCATED_STORAGE_FIELD,
            STATUS_FIELD, PORT_FIELD, AVAILABILITY_ZONE_FIELD, VPC_ID_FIELD, INSTANCE_CREATE_TIME_FIELD, MASTER_USERNAME_FIELD,
            ENGINE_FIELD, ENGINE_VERSION_FIELD, LICENSE_MODEL_FIELD, IOPS_FIELD, OPTION_GROUP_NAME_FIELD,
            TDE_CREDENTIAL_ARN_FIELD, ENCRYPTED_FIELD, STORAGE_TYPE_FIELD, KMS_KEY_ID_FIELD, TIMEZONE_FIELD,
            IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD, BACKUP_RETENTION_PERIOD_FIELD, DB_INSTANCE_AUTOMATED_BACKUPS_ARN_FIELD,
            DB_INSTANCE_AUTOMATED_BACKUPS_REPLICATIONS_FIELD, BACKUP_TARGET_FIELD, STORAGE_THROUGHPUT_FIELD,
            AWS_BACKUP_RECOVERY_POINT_ARN_FIELD, DEDICATED_LOG_VOLUME_FIELD, MULTI_TENANT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dbInstanceArn;

    private final String dbiResourceId;

    private final String region;

    private final String dbInstanceIdentifier;

    private final RestoreWindow restoreWindow;

    private final Integer allocatedStorage;

    private final String status;

    private final Integer port;

    private final String availabilityZone;

    private final String vpcId;

    private final Instant instanceCreateTime;

    private final String masterUsername;

    private final String engine;

    private final String engineVersion;

    private final String licenseModel;

    private final Integer iops;

    private final String optionGroupName;

    private final String tdeCredentialArn;

    private final Boolean encrypted;

    private final String storageType;

    private final String kmsKeyId;

    private final String timezone;

    private final Boolean iamDatabaseAuthenticationEnabled;

    private final Integer backupRetentionPeriod;

    private final String dbInstanceAutomatedBackupsArn;

    private final List<DBInstanceAutomatedBackupsReplication> dbInstanceAutomatedBackupsReplications;

    private final String backupTarget;

    private final Integer storageThroughput;

    private final String awsBackupRecoveryPointArn;

    private final Boolean dedicatedLogVolume;

    private final Boolean multiTenant;

    private DBInstanceAutomatedBackup(BuilderImpl builder) {
        this.dbInstanceArn = builder.dbInstanceArn;
        this.dbiResourceId = builder.dbiResourceId;
        this.region = builder.region;
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.restoreWindow = builder.restoreWindow;
        this.allocatedStorage = builder.allocatedStorage;
        this.status = builder.status;
        this.port = builder.port;
        this.availabilityZone = builder.availabilityZone;
        this.vpcId = builder.vpcId;
        this.instanceCreateTime = builder.instanceCreateTime;
        this.masterUsername = builder.masterUsername;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.licenseModel = builder.licenseModel;
        this.iops = builder.iops;
        this.optionGroupName = builder.optionGroupName;
        this.tdeCredentialArn = builder.tdeCredentialArn;
        this.encrypted = builder.encrypted;
        this.storageType = builder.storageType;
        this.kmsKeyId = builder.kmsKeyId;
        this.timezone = builder.timezone;
        this.iamDatabaseAuthenticationEnabled = builder.iamDatabaseAuthenticationEnabled;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.dbInstanceAutomatedBackupsArn = builder.dbInstanceAutomatedBackupsArn;
        this.dbInstanceAutomatedBackupsReplications = builder.dbInstanceAutomatedBackupsReplications;
        this.backupTarget = builder.backupTarget;
        this.storageThroughput = builder.storageThroughput;
        this.awsBackupRecoveryPointArn = builder.awsBackupRecoveryPointArn;
        this.dedicatedLogVolume = builder.dedicatedLogVolume;
        this.multiTenant = builder.multiTenant;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the automated backups.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the automated backups.
     */
    public final String dbInstanceArn() {
        return dbInstanceArn;
    }

    /**
     * <p>
     * The resource ID for the source DB instance, which can't be changed and which is unique to an Amazon Web Services
     * Region.
     * </p>
     * 
     * @return The resource ID for the source DB instance, which can't be changed and which is unique to an Amazon Web
     *         Services Region.
     */
    public final String dbiResourceId() {
        return dbiResourceId;
    }

    /**
     * <p>
     * The Amazon Web Services Region associated with the automated backup.
     * </p>
     * 
     * @return The Amazon Web Services Region associated with the automated backup.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The identifier for the source DB instance, which can't be changed and which is unique to an Amazon Web Services
     * Region.
     * </p>
     * 
     * @return The identifier for the source DB instance, which can't be changed and which is unique to an Amazon Web
     *         Services Region.
     */
    public final String dbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    /**
     * <p>
     * The earliest and latest time a DB instance can be restored to.
     * </p>
     * 
     * @return The earliest and latest time a DB instance can be restored to.
     */
    public final RestoreWindow restoreWindow() {
        return restoreWindow;
    }

    /**
     * <p>
     * The allocated storage size for the the automated backup in gibibytes (GiB).
     * </p>
     * 
     * @return The allocated storage size for the the automated backup in gibibytes (GiB).
     */
    public final Integer allocatedStorage() {
        return allocatedStorage;
    }

    /**
     * <p>
     * A list of status information for an automated backup:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>active</code> - Automated backups for current instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>retained</code> - Automated backups for deleted instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>creating</code> - Automated backups that are waiting for the first automated snapshot to be available.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A list of status information for an automated backup:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>active</code> - Automated backups for current instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>retained</code> - Automated backups for deleted instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>creating</code> - Automated backups that are waiting for the first automated snapshot to be
     *         available.
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The port number that the automated backup used for connections.
     * </p>
     * <p>
     * Default: Inherits from the source DB instance
     * </p>
     * <p>
     * Valid Values: <code>1150-65535</code>
     * </p>
     * 
     * @return The port number that the automated backup used for connections.</p>
     *         <p>
     *         Default: Inherits from the source DB instance
     *         </p>
     *         <p>
     *         Valid Values: <code>1150-65535</code>
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The Availability Zone that the automated backup was created in. For information on Amazon Web Services Regions
     * and Availability Zones, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions
     * and Availability Zones</a>.
     * </p>
     * 
     * @return The Availability Zone that the automated backup was created in. For information on Amazon Web Services
     *         Regions and Availability Zones, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html"
     *         >Regions and Availability Zones</a>.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The VPC ID associated with the DB instance.
     * </p>
     * 
     * @return The VPC ID associated with the DB instance.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The date and time when the DB instance was created.
     * </p>
     * 
     * @return The date and time when the DB instance was created.
     */
    public final Instant instanceCreateTime() {
        return instanceCreateTime;
    }

    /**
     * <p>
     * The master user name of an automated backup.
     * </p>
     * 
     * @return The master user name of an automated backup.
     */
    public final String masterUsername() {
        return masterUsername;
    }

    /**
     * <p>
     * The name of the database engine for this automated backup.
     * </p>
     * 
     * @return The name of the database engine for this automated backup.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The version of the database engine for the automated backup.
     * </p>
     * 
     * @return The version of the database engine for the automated backup.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The license model information for the automated backup.
     * </p>
     * 
     * @return The license model information for the automated backup.
     */
    public final String licenseModel() {
        return licenseModel;
    }

    /**
     * <p>
     * The IOPS (I/O operations per second) value for the automated backup.
     * </p>
     * 
     * @return The IOPS (I/O operations per second) value for the automated backup.
     */
    public final Integer iops() {
        return iops;
    }

    /**
     * <p>
     * The option group the automated backup is associated with. If omitted, the default option group for the engine
     * specified is used.
     * </p>
     * 
     * @return The option group the automated backup is associated with. If omitted, the default option group for the
     *         engine specified is used.
     */
    public final String optionGroupName() {
        return optionGroupName;
    }

    /**
     * <p>
     * The ARN from the key store with which the automated backup is associated for TDE encryption.
     * </p>
     * 
     * @return The ARN from the key store with which the automated backup is associated for TDE encryption.
     */
    public final String tdeCredentialArn() {
        return tdeCredentialArn;
    }

    /**
     * <p>
     * Indicates whether the automated backup is encrypted.
     * </p>
     * 
     * @return Indicates whether the automated backup is encrypted.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The storage type associated with the automated backup.
     * </p>
     * 
     * @return The storage type associated with the automated backup.
     */
    public final String storageType() {
        return storageType;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key ID for an automated backup.
     * </p>
     * <p>
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     * </p>
     * 
     * @return The Amazon Web Services KMS key ID for an automated backup.</p>
     *         <p>
     *         The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS
     *         key.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The time zone of the automated backup. In most cases, the <code>Timezone</code> element is empty.
     * <code>Timezone</code> content appears only for Microsoft SQL Server DB instances that were created with a time
     * zone specified.
     * </p>
     * 
     * @return The time zone of the automated backup. In most cases, the <code>Timezone</code> element is empty.
     *         <code>Timezone</code> content appears only for Microsoft SQL Server DB instances that were created with a
     *         time zone specified.
     */
    public final String timezone() {
        return timezone;
    }

    /**
     * <p>
     * True if mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is
     * enabled, and otherwise false.
     * </p>
     * 
     * @return True if mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts
     *         is enabled, and otherwise false.
     */
    public final Boolean iamDatabaseAuthenticationEnabled() {
        return iamDatabaseAuthenticationEnabled;
    }

    /**
     * <p>
     * The retention period for the automated backups.
     * </p>
     * 
     * @return The retention period for the automated backups.
     */
    public final Integer backupRetentionPeriod() {
        return backupRetentionPeriod;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the replicated automated backups.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the replicated automated backups.
     */
    public final String dbInstanceAutomatedBackupsArn() {
        return dbInstanceAutomatedBackupsArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the DBInstanceAutomatedBackupsReplications
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasDbInstanceAutomatedBackupsReplications() {
        return dbInstanceAutomatedBackupsReplications != null
                && !(dbInstanceAutomatedBackupsReplications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of replications to different Amazon Web Services Regions associated with the automated backup.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDbInstanceAutomatedBackupsReplications}
     * method.
     * </p>
     * 
     * @return The list of replications to different Amazon Web Services Regions associated with the automated backup.
     */
    public final List<DBInstanceAutomatedBackupsReplication> dbInstanceAutomatedBackupsReplications() {
        return dbInstanceAutomatedBackupsReplications;
    }

    /**
     * <p>
     * The location where automated backups are stored: Dedicated Local Zones, Amazon Web Services Outposts or the
     * Amazon Web Services Region.
     * </p>
     * 
     * @return The location where automated backups are stored: Dedicated Local Zones, Amazon Web Services Outposts or
     *         the Amazon Web Services Region.
     */
    public final String backupTarget() {
        return backupTarget;
    }

    /**
     * <p>
     * The storage throughput for the automated backup.
     * </p>
     * 
     * @return The storage throughput for the automated backup.
     */
    public final Integer storageThroughput() {
        return storageThroughput;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.
     */
    public final String awsBackupRecoveryPointArn() {
        return awsBackupRecoveryPointArn;
    }

    /**
     * <p>
     * Indicates whether the DB instance has a dedicated log volume (DLV) enabled.
     * </p>
     * 
     * @return Indicates whether the DB instance has a dedicated log volume (DLV) enabled.
     */
    public final Boolean dedicatedLogVolume() {
        return dedicatedLogVolume;
    }

    /**
     * <p>
     * Specifies whether the automatic backup is for a DB instance in the multi-tenant configuration (TRUE) or the
     * single-tenant configuration (FALSE).
     * </p>
     * 
     * @return Specifies whether the automatic backup is for a DB instance in the multi-tenant configuration (TRUE) or
     *         the single-tenant configuration (FALSE).
     */
    public final Boolean multiTenant() {
        return multiTenant;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(dbiResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(restoreWindow());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(tdeCredentialArn());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(storageType());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        hashCode = 31 * hashCode + Objects.hashCode(iamDatabaseAuthenticationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceAutomatedBackupsArn());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasDbInstanceAutomatedBackupsReplications() ? dbInstanceAutomatedBackupsReplications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(backupTarget());
        hashCode = 31 * hashCode + Objects.hashCode(storageThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(awsBackupRecoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(dedicatedLogVolume());
        hashCode = 31 * hashCode + Objects.hashCode(multiTenant());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBInstanceAutomatedBackup)) {
            return false;
        }
        DBInstanceAutomatedBackup other = (DBInstanceAutomatedBackup) obj;
        return Objects.equals(dbInstanceArn(), other.dbInstanceArn()) && Objects.equals(dbiResourceId(), other.dbiResourceId())
                && Objects.equals(region(), other.region())
                && Objects.equals(dbInstanceIdentifier(), other.dbInstanceIdentifier())
                && Objects.equals(restoreWindow(), other.restoreWindow())
                && Objects.equals(allocatedStorage(), other.allocatedStorage()) && Objects.equals(status(), other.status())
                && Objects.equals(port(), other.port()) && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(vpcId(), other.vpcId()) && Objects.equals(instanceCreateTime(), other.instanceCreateTime())
                && Objects.equals(masterUsername(), other.masterUsername()) && Objects.equals(engine(), other.engine())
                && Objects.equals(engineVersion(), other.engineVersion()) && Objects.equals(licenseModel(), other.licenseModel())
                && Objects.equals(iops(), other.iops()) && Objects.equals(optionGroupName(), other.optionGroupName())
                && Objects.equals(tdeCredentialArn(), other.tdeCredentialArn()) && Objects.equals(encrypted(), other.encrypted())
                && Objects.equals(storageType(), other.storageType()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(timezone(), other.timezone())
                && Objects.equals(iamDatabaseAuthenticationEnabled(), other.iamDatabaseAuthenticationEnabled())
                && Objects.equals(backupRetentionPeriod(), other.backupRetentionPeriod())
                && Objects.equals(dbInstanceAutomatedBackupsArn(), other.dbInstanceAutomatedBackupsArn())
                && hasDbInstanceAutomatedBackupsReplications() == other.hasDbInstanceAutomatedBackupsReplications()
                && Objects.equals(dbInstanceAutomatedBackupsReplications(), other.dbInstanceAutomatedBackupsReplications())
                && Objects.equals(backupTarget(), other.backupTarget())
                && Objects.equals(storageThroughput(), other.storageThroughput())
                && Objects.equals(awsBackupRecoveryPointArn(), other.awsBackupRecoveryPointArn())
                && Objects.equals(dedicatedLogVolume(), other.dedicatedLogVolume())
                && Objects.equals(multiTenant(), other.multiTenant());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DBInstanceAutomatedBackup")
                .add("DBInstanceArn", dbInstanceArn())
                .add("DbiResourceId", dbiResourceId())
                .add("Region", region())
                .add("DBInstanceIdentifier", dbInstanceIdentifier())
                .add("RestoreWindow", restoreWindow())
                .add("AllocatedStorage", allocatedStorage())
                .add("Status", status())
                .add("Port", port())
                .add("AvailabilityZone", availabilityZone())
                .add("VpcId", vpcId())
                .add("InstanceCreateTime", instanceCreateTime())
                .add("MasterUsername", masterUsername())
                .add("Engine", engine())
                .add("EngineVersion", engineVersion())
                .add("LicenseModel", licenseModel())
                .add("Iops", iops())
                .add("OptionGroupName", optionGroupName())
                .add("TdeCredentialArn", tdeCredentialArn())
                .add("Encrypted", encrypted())
                .add("StorageType", storageType())
                .add("KmsKeyId", kmsKeyId())
                .add("Timezone", timezone())
                .add("IAMDatabaseAuthenticationEnabled", iamDatabaseAuthenticationEnabled())
                .add("BackupRetentionPeriod", backupRetentionPeriod())
                .add("DBInstanceAutomatedBackupsArn", dbInstanceAutomatedBackupsArn())
                .add("DBInstanceAutomatedBackupsReplications",
                        hasDbInstanceAutomatedBackupsReplications() ? dbInstanceAutomatedBackupsReplications() : null)
                .add("BackupTarget", backupTarget()).add("StorageThroughput", storageThroughput())
                .add("AwsBackupRecoveryPointArn", awsBackupRecoveryPointArn()).add("DedicatedLogVolume", dedicatedLogVolume())
                .add("MultiTenant", multiTenant()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBInstanceArn":
            return Optional.ofNullable(clazz.cast(dbInstanceArn()));
        case "DbiResourceId":
            return Optional.ofNullable(clazz.cast(dbiResourceId()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "DBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(dbInstanceIdentifier()));
        case "RestoreWindow":
            return Optional.ofNullable(clazz.cast(restoreWindow()));
        case "AllocatedStorage":
            return Optional.ofNullable(clazz.cast(allocatedStorage()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "InstanceCreateTime":
            return Optional.ofNullable(clazz.cast(instanceCreateTime()));
        case "MasterUsername":
            return Optional.ofNullable(clazz.cast(masterUsername()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "LicenseModel":
            return Optional.ofNullable(clazz.cast(licenseModel()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "OptionGroupName":
            return Optional.ofNullable(clazz.cast(optionGroupName()));
        case "TdeCredentialArn":
            return Optional.ofNullable(clazz.cast(tdeCredentialArn()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageType()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "Timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        case "IAMDatabaseAuthenticationEnabled":
            return Optional.ofNullable(clazz.cast(iamDatabaseAuthenticationEnabled()));
        case "BackupRetentionPeriod":
            return Optional.ofNullable(clazz.cast(backupRetentionPeriod()));
        case "DBInstanceAutomatedBackupsArn":
            return Optional.ofNullable(clazz.cast(dbInstanceAutomatedBackupsArn()));
        case "DBInstanceAutomatedBackupsReplications":
            return Optional.ofNullable(clazz.cast(dbInstanceAutomatedBackupsReplications()));
        case "BackupTarget":
            return Optional.ofNullable(clazz.cast(backupTarget()));
        case "StorageThroughput":
            return Optional.ofNullable(clazz.cast(storageThroughput()));
        case "AwsBackupRecoveryPointArn":
            return Optional.ofNullable(clazz.cast(awsBackupRecoveryPointArn()));
        case "DedicatedLogVolume":
            return Optional.ofNullable(clazz.cast(dedicatedLogVolume()));
        case "MultiTenant":
            return Optional.ofNullable(clazz.cast(multiTenant()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DBInstanceArn", DB_INSTANCE_ARN_FIELD);
        map.put("DbiResourceId", DBI_RESOURCE_ID_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("DBInstanceIdentifier", DB_INSTANCE_IDENTIFIER_FIELD);
        map.put("RestoreWindow", RESTORE_WINDOW_FIELD);
        map.put("AllocatedStorage", ALLOCATED_STORAGE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("InstanceCreateTime", INSTANCE_CREATE_TIME_FIELD);
        map.put("MasterUsername", MASTER_USERNAME_FIELD);
        map.put("Engine", ENGINE_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("LicenseModel", LICENSE_MODEL_FIELD);
        map.put("Iops", IOPS_FIELD);
        map.put("OptionGroupName", OPTION_GROUP_NAME_FIELD);
        map.put("TdeCredentialArn", TDE_CREDENTIAL_ARN_FIELD);
        map.put("Encrypted", ENCRYPTED_FIELD);
        map.put("StorageType", STORAGE_TYPE_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("Timezone", TIMEZONE_FIELD);
        map.put("IAMDatabaseAuthenticationEnabled", IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD);
        map.put("BackupRetentionPeriod", BACKUP_RETENTION_PERIOD_FIELD);
        map.put("DBInstanceAutomatedBackupsArn", DB_INSTANCE_AUTOMATED_BACKUPS_ARN_FIELD);
        map.put("DBInstanceAutomatedBackupsReplications", DB_INSTANCE_AUTOMATED_BACKUPS_REPLICATIONS_FIELD);
        map.put("BackupTarget", BACKUP_TARGET_FIELD);
        map.put("StorageThroughput", STORAGE_THROUGHPUT_FIELD);
        map.put("AwsBackupRecoveryPointArn", AWS_BACKUP_RECOVERY_POINT_ARN_FIELD);
        map.put("DedicatedLogVolume", DEDICATED_LOG_VOLUME_FIELD);
        map.put("MultiTenant", MULTI_TENANT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DBInstanceAutomatedBackup, T> g) {
        return obj -> g.apply((DBInstanceAutomatedBackup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DBInstanceAutomatedBackup> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the automated backups.
         * </p>
         * 
         * @param dbInstanceArn
         *        The Amazon Resource Name (ARN) for the automated backups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceArn(String dbInstanceArn);

        /**
         * <p>
         * The resource ID for the source DB instance, which can't be changed and which is unique to an Amazon Web
         * Services Region.
         * </p>
         * 
         * @param dbiResourceId
         *        The resource ID for the source DB instance, which can't be changed and which is unique to an Amazon
         *        Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbiResourceId(String dbiResourceId);

        /**
         * <p>
         * The Amazon Web Services Region associated with the automated backup.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region associated with the automated backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The identifier for the source DB instance, which can't be changed and which is unique to an Amazon Web
         * Services Region.
         * </p>
         * 
         * @param dbInstanceIdentifier
         *        The identifier for the source DB instance, which can't be changed and which is unique to an Amazon Web
         *        Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifier(String dbInstanceIdentifier);

        /**
         * <p>
         * The earliest and latest time a DB instance can be restored to.
         * </p>
         * 
         * @param restoreWindow
         *        The earliest and latest time a DB instance can be restored to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreWindow(RestoreWindow restoreWindow);

        /**
         * <p>
         * The earliest and latest time a DB instance can be restored to.
         * </p>
         * This is a convenience method that creates an instance of the {@link RestoreWindow.Builder} avoiding the need
         * to create one manually via {@link RestoreWindow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RestoreWindow.Builder#build()} is called immediately and its
         * result is passed to {@link #restoreWindow(RestoreWindow)}.
         * 
         * @param restoreWindow
         *        a consumer that will call methods on {@link RestoreWindow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restoreWindow(RestoreWindow)
         */
        default Builder restoreWindow(Consumer<RestoreWindow.Builder> restoreWindow) {
            return restoreWindow(RestoreWindow.builder().applyMutation(restoreWindow).build());
        }

        /**
         * <p>
         * The allocated storage size for the the automated backup in gibibytes (GiB).
         * </p>
         * 
         * @param allocatedStorage
         *        The allocated storage size for the the automated backup in gibibytes (GiB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedStorage(Integer allocatedStorage);

        /**
         * <p>
         * A list of status information for an automated backup:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>active</code> - Automated backups for current instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>retained</code> - Automated backups for deleted instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>creating</code> - Automated backups that are waiting for the first automated snapshot to be available.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        A list of status information for an automated backup:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>active</code> - Automated backups for current instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>retained</code> - Automated backups for deleted instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>creating</code> - Automated backups that are waiting for the first automated snapshot to be
         *        available.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The port number that the automated backup used for connections.
         * </p>
         * <p>
         * Default: Inherits from the source DB instance
         * </p>
         * <p>
         * Valid Values: <code>1150-65535</code>
         * </p>
         * 
         * @param port
         *        The port number that the automated backup used for connections.</p>
         *        <p>
         *        Default: Inherits from the source DB instance
         *        </p>
         *        <p>
         *        Valid Values: <code>1150-65535</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The Availability Zone that the automated backup was created in. For information on Amazon Web Services
         * Regions and Availability Zones, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html"
         * >Regions and Availability Zones</a>.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone that the automated backup was created in. For information on Amazon Web Services
         *        Regions and Availability Zones, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html"
         *        >Regions and Availability Zones</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The VPC ID associated with the DB instance.
         * </p>
         * 
         * @param vpcId
         *        The VPC ID associated with the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The date and time when the DB instance was created.
         * </p>
         * 
         * @param instanceCreateTime
         *        The date and time when the DB instance was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCreateTime(Instant instanceCreateTime);

        /**
         * <p>
         * The master user name of an automated backup.
         * </p>
         * 
         * @param masterUsername
         *        The master user name of an automated backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUsername(String masterUsername);

        /**
         * <p>
         * The name of the database engine for this automated backup.
         * </p>
         * 
         * @param engine
         *        The name of the database engine for this automated backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The version of the database engine for the automated backup.
         * </p>
         * 
         * @param engineVersion
         *        The version of the database engine for the automated backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The license model information for the automated backup.
         * </p>
         * 
         * @param licenseModel
         *        The license model information for the automated backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseModel(String licenseModel);

        /**
         * <p>
         * The IOPS (I/O operations per second) value for the automated backup.
         * </p>
         * 
         * @param iops
         *        The IOPS (I/O operations per second) value for the automated backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * The option group the automated backup is associated with. If omitted, the default option group for the engine
         * specified is used.
         * </p>
         * 
         * @param optionGroupName
         *        The option group the automated backup is associated with. If omitted, the default option group for the
         *        engine specified is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupName(String optionGroupName);

        /**
         * <p>
         * The ARN from the key store with which the automated backup is associated for TDE encryption.
         * </p>
         * 
         * @param tdeCredentialArn
         *        The ARN from the key store with which the automated backup is associated for TDE encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tdeCredentialArn(String tdeCredentialArn);

        /**
         * <p>
         * Indicates whether the automated backup is encrypted.
         * </p>
         * 
         * @param encrypted
         *        Indicates whether the automated backup is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The storage type associated with the automated backup.
         * </p>
         * 
         * @param storageType
         *        The storage type associated with the automated backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The Amazon Web Services KMS key ID for an automated backup.
         * </p>
         * <p>
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Web Services KMS key ID for an automated backup.</p>
         *        <p>
         *        The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the
         *        KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The time zone of the automated backup. In most cases, the <code>Timezone</code> element is empty.
         * <code>Timezone</code> content appears only for Microsoft SQL Server DB instances that were created with a
         * time zone specified.
         * </p>
         * 
         * @param timezone
         *        The time zone of the automated backup. In most cases, the <code>Timezone</code> element is empty.
         *        <code>Timezone</code> content appears only for Microsoft SQL Server DB instances that were created
         *        with a time zone specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);

        /**
         * <p>
         * True if mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is
         * enabled, and otherwise false.
         * </p>
         * 
         * @param iamDatabaseAuthenticationEnabled
         *        True if mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database
         *        accounts is enabled, and otherwise false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled);

        /**
         * <p>
         * The retention period for the automated backups.
         * </p>
         * 
         * @param backupRetentionPeriod
         *        The retention period for the automated backups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRetentionPeriod(Integer backupRetentionPeriod);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the replicated automated backups.
         * </p>
         * 
         * @param dbInstanceAutomatedBackupsArn
         *        The Amazon Resource Name (ARN) for the replicated automated backups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceAutomatedBackupsArn(String dbInstanceAutomatedBackupsArn);

        /**
         * <p>
         * The list of replications to different Amazon Web Services Regions associated with the automated backup.
         * </p>
         * 
         * @param dbInstanceAutomatedBackupsReplications
         *        The list of replications to different Amazon Web Services Regions associated with the automated
         *        backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceAutomatedBackupsReplications(
                Collection<DBInstanceAutomatedBackupsReplication> dbInstanceAutomatedBackupsReplications);

        /**
         * <p>
         * The list of replications to different Amazon Web Services Regions associated with the automated backup.
         * </p>
         * 
         * @param dbInstanceAutomatedBackupsReplications
         *        The list of replications to different Amazon Web Services Regions associated with the automated
         *        backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceAutomatedBackupsReplications(
                DBInstanceAutomatedBackupsReplication... dbInstanceAutomatedBackupsReplications);

        /**
         * <p>
         * The list of replications to different Amazon Web Services Regions associated with the automated backup.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackupsReplication.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackupsReplication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackupsReplication.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #dbInstanceAutomatedBackupsReplications(List<DBInstanceAutomatedBackupsReplication>)}.
         * 
         * @param dbInstanceAutomatedBackupsReplications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackupsReplication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbInstanceAutomatedBackupsReplications(java.util.Collection<DBInstanceAutomatedBackupsReplication>)
         */
        Builder dbInstanceAutomatedBackupsReplications(
                Consumer<DBInstanceAutomatedBackupsReplication.Builder>... dbInstanceAutomatedBackupsReplications);

        /**
         * <p>
         * The location where automated backups are stored: Dedicated Local Zones, Amazon Web Services Outposts or the
         * Amazon Web Services Region.
         * </p>
         * 
         * @param backupTarget
         *        The location where automated backups are stored: Dedicated Local Zones, Amazon Web Services Outposts
         *        or the Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupTarget(String backupTarget);

        /**
         * <p>
         * The storage throughput for the automated backup.
         * </p>
         * 
         * @param storageThroughput
         *        The storage throughput for the automated backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageThroughput(Integer storageThroughput);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.
         * </p>
         * 
         * @param awsBackupRecoveryPointArn
         *        The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsBackupRecoveryPointArn(String awsBackupRecoveryPointArn);

        /**
         * <p>
         * Indicates whether the DB instance has a dedicated log volume (DLV) enabled.
         * </p>
         * 
         * @param dedicatedLogVolume
         *        Indicates whether the DB instance has a dedicated log volume (DLV) enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dedicatedLogVolume(Boolean dedicatedLogVolume);

        /**
         * <p>
         * Specifies whether the automatic backup is for a DB instance in the multi-tenant configuration (TRUE) or the
         * single-tenant configuration (FALSE).
         * </p>
         * 
         * @param multiTenant
         *        Specifies whether the automatic backup is for a DB instance in the multi-tenant configuration (TRUE)
         *        or the single-tenant configuration (FALSE).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiTenant(Boolean multiTenant);
    }

    static final class BuilderImpl implements Builder {
        private String dbInstanceArn;

        private String dbiResourceId;

        private String region;

        private String dbInstanceIdentifier;

        private RestoreWindow restoreWindow;

        private Integer allocatedStorage;

        private String status;

        private Integer port;

        private String availabilityZone;

        private String vpcId;

        private Instant instanceCreateTime;

        private String masterUsername;

        private String engine;

        private String engineVersion;

        private String licenseModel;

        private Integer iops;

        private String optionGroupName;

        private String tdeCredentialArn;

        private Boolean encrypted;

        private String storageType;

        private String kmsKeyId;

        private String timezone;

        private Boolean iamDatabaseAuthenticationEnabled;

        private Integer backupRetentionPeriod;

        private String dbInstanceAutomatedBackupsArn;

        private List<DBInstanceAutomatedBackupsReplication> dbInstanceAutomatedBackupsReplications = DefaultSdkAutoConstructList
                .getInstance();

        private String backupTarget;

        private Integer storageThroughput;

        private String awsBackupRecoveryPointArn;

        private Boolean dedicatedLogVolume;

        private Boolean multiTenant;

        private BuilderImpl() {
        }

        private BuilderImpl(DBInstanceAutomatedBackup model) {
            dbInstanceArn(model.dbInstanceArn);
            dbiResourceId(model.dbiResourceId);
            region(model.region);
            dbInstanceIdentifier(model.dbInstanceIdentifier);
            restoreWindow(model.restoreWindow);
            allocatedStorage(model.allocatedStorage);
            status(model.status);
            port(model.port);
            availabilityZone(model.availabilityZone);
            vpcId(model.vpcId);
            instanceCreateTime(model.instanceCreateTime);
            masterUsername(model.masterUsername);
            engine(model.engine);
            engineVersion(model.engineVersion);
            licenseModel(model.licenseModel);
            iops(model.iops);
            optionGroupName(model.optionGroupName);
            tdeCredentialArn(model.tdeCredentialArn);
            encrypted(model.encrypted);
            storageType(model.storageType);
            kmsKeyId(model.kmsKeyId);
            timezone(model.timezone);
            iamDatabaseAuthenticationEnabled(model.iamDatabaseAuthenticationEnabled);
            backupRetentionPeriod(model.backupRetentionPeriod);
            dbInstanceAutomatedBackupsArn(model.dbInstanceAutomatedBackupsArn);
            dbInstanceAutomatedBackupsReplications(model.dbInstanceAutomatedBackupsReplications);
            backupTarget(model.backupTarget);
            storageThroughput(model.storageThroughput);
            awsBackupRecoveryPointArn(model.awsBackupRecoveryPointArn);
            dedicatedLogVolume(model.dedicatedLogVolume);
            multiTenant(model.multiTenant);
        }

        public final String getDbInstanceArn() {
            return dbInstanceArn;
        }

        public final void setDbInstanceArn(String dbInstanceArn) {
            this.dbInstanceArn = dbInstanceArn;
        }

        @Override
        public final Builder dbInstanceArn(String dbInstanceArn) {
            this.dbInstanceArn = dbInstanceArn;
            return this;
        }

        public final String getDbiResourceId() {
            return dbiResourceId;
        }

        public final void setDbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
        }

        @Override
        public final Builder dbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getDbInstanceIdentifier() {
            return dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final RestoreWindow.Builder getRestoreWindow() {
            return restoreWindow != null ? restoreWindow.toBuilder() : null;
        }

        public final void setRestoreWindow(RestoreWindow.BuilderImpl restoreWindow) {
            this.restoreWindow = restoreWindow != null ? restoreWindow.build() : null;
        }

        @Override
        public final Builder restoreWindow(RestoreWindow restoreWindow) {
            this.restoreWindow = restoreWindow;
            return this;
        }

        public final Integer getAllocatedStorage() {
            return allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Instant getInstanceCreateTime() {
            return instanceCreateTime;
        }

        public final void setInstanceCreateTime(Instant instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
        }

        @Override
        public final Builder instanceCreateTime(Instant instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
            return this;
        }

        public final String getMasterUsername() {
            return masterUsername;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getLicenseModel() {
            return licenseModel;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final Integer getIops() {
            return iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final String getOptionGroupName() {
            return optionGroupName;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final String getTdeCredentialArn() {
            return tdeCredentialArn;
        }

        public final void setTdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
        }

        @Override
        public final Builder tdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
            return this;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getTimezone() {
            return timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final Boolean getIamDatabaseAuthenticationEnabled() {
            return iamDatabaseAuthenticationEnabled;
        }

        public final void setIamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
        }

        @Override
        public final Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
            return this;
        }

        public final Integer getBackupRetentionPeriod() {
            return backupRetentionPeriod;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final String getDbInstanceAutomatedBackupsArn() {
            return dbInstanceAutomatedBackupsArn;
        }

        public final void setDbInstanceAutomatedBackupsArn(String dbInstanceAutomatedBackupsArn) {
            this.dbInstanceAutomatedBackupsArn = dbInstanceAutomatedBackupsArn;
        }

        @Override
        public final Builder dbInstanceAutomatedBackupsArn(String dbInstanceAutomatedBackupsArn) {
            this.dbInstanceAutomatedBackupsArn = dbInstanceAutomatedBackupsArn;
            return this;
        }

        public final List<DBInstanceAutomatedBackupsReplication.Builder> getDbInstanceAutomatedBackupsReplications() {
            List<DBInstanceAutomatedBackupsReplication.Builder> result = DBInstanceAutomatedBackupsReplicationListCopier
                    .copyToBuilder(this.dbInstanceAutomatedBackupsReplications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbInstanceAutomatedBackupsReplications(
                Collection<DBInstanceAutomatedBackupsReplication.BuilderImpl> dbInstanceAutomatedBackupsReplications) {
            this.dbInstanceAutomatedBackupsReplications = DBInstanceAutomatedBackupsReplicationListCopier
                    .copyFromBuilder(dbInstanceAutomatedBackupsReplications);
        }

        @Override
        public final Builder dbInstanceAutomatedBackupsReplications(
                Collection<DBInstanceAutomatedBackupsReplication> dbInstanceAutomatedBackupsReplications) {
            this.dbInstanceAutomatedBackupsReplications = DBInstanceAutomatedBackupsReplicationListCopier
                    .copy(dbInstanceAutomatedBackupsReplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbInstanceAutomatedBackupsReplications(
                DBInstanceAutomatedBackupsReplication... dbInstanceAutomatedBackupsReplications) {
            dbInstanceAutomatedBackupsReplications(Arrays.asList(dbInstanceAutomatedBackupsReplications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbInstanceAutomatedBackupsReplications(
                Consumer<DBInstanceAutomatedBackupsReplication.Builder>... dbInstanceAutomatedBackupsReplications) {
            dbInstanceAutomatedBackupsReplications(Stream.of(dbInstanceAutomatedBackupsReplications)
                    .map(c -> DBInstanceAutomatedBackupsReplication.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getBackupTarget() {
            return backupTarget;
        }

        public final void setBackupTarget(String backupTarget) {
            this.backupTarget = backupTarget;
        }

        @Override
        public final Builder backupTarget(String backupTarget) {
            this.backupTarget = backupTarget;
            return this;
        }

        public final Integer getStorageThroughput() {
            return storageThroughput;
        }

        public final void setStorageThroughput(Integer storageThroughput) {
            this.storageThroughput = storageThroughput;
        }

        @Override
        public final Builder storageThroughput(Integer storageThroughput) {
            this.storageThroughput = storageThroughput;
            return this;
        }

        public final String getAwsBackupRecoveryPointArn() {
            return awsBackupRecoveryPointArn;
        }

        public final void setAwsBackupRecoveryPointArn(String awsBackupRecoveryPointArn) {
            this.awsBackupRecoveryPointArn = awsBackupRecoveryPointArn;
        }

        @Override
        public final Builder awsBackupRecoveryPointArn(String awsBackupRecoveryPointArn) {
            this.awsBackupRecoveryPointArn = awsBackupRecoveryPointArn;
            return this;
        }

        public final Boolean getDedicatedLogVolume() {
            return dedicatedLogVolume;
        }

        public final void setDedicatedLogVolume(Boolean dedicatedLogVolume) {
            this.dedicatedLogVolume = dedicatedLogVolume;
        }

        @Override
        public final Builder dedicatedLogVolume(Boolean dedicatedLogVolume) {
            this.dedicatedLogVolume = dedicatedLogVolume;
            return this;
        }

        public final Boolean getMultiTenant() {
            return multiTenant;
        }

        public final void setMultiTenant(Boolean multiTenant) {
            this.multiTenant = multiTenant;
        }

        @Override
        public final Builder multiTenant(Boolean multiTenant) {
            this.multiTenant = multiTenant;
            return this;
        }

        @Override
        public DBInstanceAutomatedBackup build() {
            return new DBInstanceAutomatedBackup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
