/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Amazon Web Services Identity and Access Management (IAM) role that is associated with a DB cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DBClusterRole implements SdkPojo, Serializable, ToCopyableBuilder<DBClusterRole.Builder, DBClusterRole> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DBClusterRole::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DBClusterRole::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> FEATURE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureName").getter(getter(DBClusterRole::featureName)).setter(setter(Builder::featureName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, STATUS_FIELD,
            FEATURE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final String status;

    private final String featureName;

    private DBClusterRole(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.featureName = builder.featureName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Describes the state of association between the IAM role and the DB cluster. The Status property returns one of
     * the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> - the IAM role ARN is associated with the DB cluster and can be used to access other Amazon
     * Web Services on your behalf.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING</code> - the IAM role ARN is being associated with the DB cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INVALID</code> - the IAM role ARN is associated with the DB cluster, but the DB cluster is unable to assume
     * the IAM role in order to access other Amazon Web Services on your behalf.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Describes the state of association between the IAM role and the DB cluster. The Status property returns
     *         one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - the IAM role ARN is associated with the DB cluster and can be used to access other
     *         Amazon Web Services on your behalf.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING</code> - the IAM role ARN is being associated with the DB cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INVALID</code> - the IAM role ARN is associated with the DB cluster, but the DB cluster is unable
     *         to assume the IAM role in order to access other Amazon Web Services on your behalf.
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The name of the feature associated with the Amazon Web Services Identity and Access Management (IAM) role. For
     * information about supported feature names, see <a>DBEngineVersion</a>.
     * </p>
     * 
     * @return The name of the feature associated with the Amazon Web Services Identity and Access Management (IAM)
     *         role. For information about supported feature names, see <a>DBEngineVersion</a>.
     */
    public final String featureName() {
        return featureName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(featureName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBClusterRole)) {
            return false;
        }
        DBClusterRole other = (DBClusterRole) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(status(), other.status())
                && Objects.equals(featureName(), other.featureName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DBClusterRole").add("RoleArn", roleArn()).add("Status", status())
                .add("FeatureName", featureName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "FeatureName":
            return Optional.ofNullable(clazz.cast(featureName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("FeatureName", FEATURE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DBClusterRole, T> g) {
        return obj -> g.apply((DBClusterRole) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DBClusterRole> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Describes the state of association between the IAM role and the DB cluster. The Status property returns one
         * of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code> - the IAM role ARN is associated with the DB cluster and can be used to access other
         * Amazon Web Services on your behalf.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING</code> - the IAM role ARN is being associated with the DB cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INVALID</code> - the IAM role ARN is associated with the DB cluster, but the DB cluster is unable to
         * assume the IAM role in order to access other Amazon Web Services on your behalf.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Describes the state of association between the IAM role and the DB cluster. The Status property
         *        returns one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - the IAM role ARN is associated with the DB cluster and can be used to access
         *        other Amazon Web Services on your behalf.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING</code> - the IAM role ARN is being associated with the DB cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INVALID</code> - the IAM role ARN is associated with the DB cluster, but the DB cluster is
         *        unable to assume the IAM role in order to access other Amazon Web Services on your behalf.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The name of the feature associated with the Amazon Web Services Identity and Access Management (IAM) role.
         * For information about supported feature names, see <a>DBEngineVersion</a>.
         * </p>
         * 
         * @param featureName
         *        The name of the feature associated with the Amazon Web Services Identity and Access Management (IAM)
         *        role. For information about supported feature names, see <a>DBEngineVersion</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureName(String featureName);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String status;

        private String featureName;

        private BuilderImpl() {
        }

        private BuilderImpl(DBClusterRole model) {
            roleArn(model.roleArn);
            status(model.status);
            featureName(model.featureName);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getFeatureName() {
            return featureName;
        }

        public final void setFeatureName(String featureName) {
            this.featureName = featureName;
        }

        @Override
        public final Builder featureName(String featureName) {
            this.featureName = featureName;
            return this;
        }

        @Override
        public DBClusterRole build() {
            return new DBClusterRole(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
