/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A configuration object that specifies the destination of an event after Lambda processes it.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DestinationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DestinationConfig.Builder, DestinationConfig> {
    private static final SdkField<OnSuccess> ON_SUCCESS_FIELD = SdkField.<OnSuccess> builder(MarshallingType.SDK_POJO)
            .memberName("OnSuccess").getter(getter(DestinationConfig::onSuccess)).setter(setter(Builder::onSuccess))
            .constructor(OnSuccess::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnSuccess").build()).build();

    private static final SdkField<OnFailure> ON_FAILURE_FIELD = SdkField.<OnFailure> builder(MarshallingType.SDK_POJO)
            .memberName("OnFailure").getter(getter(DestinationConfig::onFailure)).setter(setter(Builder::onFailure))
            .constructor(OnFailure::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnFailure").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ON_SUCCESS_FIELD,
            ON_FAILURE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final OnSuccess onSuccess;

    private final OnFailure onFailure;

    private DestinationConfig(BuilderImpl builder) {
        this.onSuccess = builder.onSuccess;
        this.onFailure = builder.onFailure;
    }

    /**
     * <p>
     * The destination configuration for successful invocations.
     * </p>
     * 
     * @return The destination configuration for successful invocations.
     */
    public final OnSuccess onSuccess() {
        return onSuccess;
    }

    /**
     * <p>
     * The destination configuration for failed invocations.
     * </p>
     * 
     * @return The destination configuration for failed invocations.
     */
    public final OnFailure onFailure() {
        return onFailure;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(onSuccess());
        hashCode = 31 * hashCode + Objects.hashCode(onFailure());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationConfig)) {
            return false;
        }
        DestinationConfig other = (DestinationConfig) obj;
        return Objects.equals(onSuccess(), other.onSuccess()) && Objects.equals(onFailure(), other.onFailure());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DestinationConfig").add("OnSuccess", onSuccess()).add("OnFailure", onFailure()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OnSuccess":
            return Optional.ofNullable(clazz.cast(onSuccess()));
        case "OnFailure":
            return Optional.ofNullable(clazz.cast(onFailure()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OnSuccess", ON_SUCCESS_FIELD);
        map.put("OnFailure", ON_FAILURE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DestinationConfig, T> g) {
        return obj -> g.apply((DestinationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DestinationConfig> {
        /**
         * <p>
         * The destination configuration for successful invocations.
         * </p>
         * 
         * @param onSuccess
         *        The destination configuration for successful invocations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onSuccess(OnSuccess onSuccess);

        /**
         * <p>
         * The destination configuration for successful invocations.
         * </p>
         * This is a convenience method that creates an instance of the {@link OnSuccess.Builder} avoiding the need to
         * create one manually via {@link OnSuccess#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OnSuccess.Builder#build()} is called immediately and its result
         * is passed to {@link #onSuccess(OnSuccess)}.
         * 
         * @param onSuccess
         *        a consumer that will call methods on {@link OnSuccess.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onSuccess(OnSuccess)
         */
        default Builder onSuccess(Consumer<OnSuccess.Builder> onSuccess) {
            return onSuccess(OnSuccess.builder().applyMutation(onSuccess).build());
        }

        /**
         * <p>
         * The destination configuration for failed invocations.
         * </p>
         * 
         * @param onFailure
         *        The destination configuration for failed invocations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onFailure(OnFailure onFailure);

        /**
         * <p>
         * The destination configuration for failed invocations.
         * </p>
         * This is a convenience method that creates an instance of the {@link OnFailure.Builder} avoiding the need to
         * create one manually via {@link OnFailure#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OnFailure.Builder#build()} is called immediately and its result
         * is passed to {@link #onFailure(OnFailure)}.
         * 
         * @param onFailure
         *        a consumer that will call methods on {@link OnFailure.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onFailure(OnFailure)
         */
        default Builder onFailure(Consumer<OnFailure.Builder> onFailure) {
            return onFailure(OnFailure.builder().applyMutation(onFailure).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OnSuccess onSuccess;

        private OnFailure onFailure;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationConfig model) {
            onSuccess(model.onSuccess);
            onFailure(model.onFailure);
        }

        public final OnSuccess.Builder getOnSuccess() {
            return onSuccess != null ? onSuccess.toBuilder() : null;
        }

        public final void setOnSuccess(OnSuccess.BuilderImpl onSuccess) {
            this.onSuccess = onSuccess != null ? onSuccess.build() : null;
        }

        @Override
        public final Builder onSuccess(OnSuccess onSuccess) {
            this.onSuccess = onSuccess;
            return this;
        }

        public final OnFailure.Builder getOnFailure() {
            return onFailure != null ? onFailure.toBuilder() : null;
        }

        public final void setOnFailure(OnFailure.BuilderImpl onFailure) {
            this.onFailure = onFailure != null ? onFailure.build() : null;
        }

        @Override
        public final Builder onFailure(OnFailure onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        @Override
        public DestinationConfig build() {
            return new DestinationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
