/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters;

import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractConfigurationConverter
implements ConfigurationConverter {
    private static final String IMPLEMENTATION = "implementation";

    protected Class getClassForImplementationHint(Class type, PlexusConfiguration configuration, ClassLoader classLoader) throws ComponentConfigurationException {
        Class<?> retValue = type;
        String implementation = configuration.getAttribute(IMPLEMENTATION, null);
        if (implementation != null) {
            try {
                retValue = classLoader.loadClass(implementation);
            }
            catch (ClassNotFoundException e) {
                String msg = "Class name which was explicitly given in configuration using 'implementation' attribute: '" + implementation + "' cannot be loaded";
                throw new ComponentConfigurationException(msg, e);
            }
        }
        return retValue;
    }

    protected Class loadClass(String classname, ClassLoader classLoader) throws ComponentConfigurationException {
        Class<?> retValue = null;
        try {
            retValue = classLoader.loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            throw new ComponentConfigurationException("Error loading class '" + classname + "'", e);
        }
        return retValue;
    }

    protected Object instantiateObject(String classname, ClassLoader classLoader) throws ComponentConfigurationException {
        Class clazz = this.loadClass(classname, classLoader);
        Object retValue = this.instantiateObject(clazz);
        return retValue;
    }

    protected Object instantiateObject(Class clazz) throws ComponentConfigurationException {
        Object retValue = null;
        try {
            retValue = clazz.newInstance();
            return retValue;
        }
        catch (IllegalAccessException e) {
            throw new ComponentConfigurationException("Class '" + clazz.getName() + "' cannot be instantiated", e);
        }
        catch (InstantiationException e) {
            throw new ComponentConfigurationException("Class '" + clazz.getName() + "' cannot be instantiated", e);
        }
    }

    protected String fromXML(String elementName) {
        return StringUtils.lowercaseFirstLetter((String)StringUtils.removeAndHump((String)elementName, (String)"-"));
    }

    protected String toXML(String fieldName) {
        return StringUtils.addAndDeHump((String)fieldName);
    }

    protected Object fromExpression(PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator, Class type) throws ComponentConfigurationException {
        Object v = this.fromExpression(configuration, expressionEvaluator);
        if (v != null && !type.isAssignableFrom(v.getClass())) {
            String msg = "Cannot assign configuration entry '" + configuration.getName() + "' to '" + type + "' from '" + configuration.getValue(null) + "', which is of type " + v.getClass();
            throw new ComponentConfigurationException(msg);
        }
        return v;
    }

    protected Object fromExpression(PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator) throws ComponentConfigurationException {
        Object v = null;
        String value = configuration.getValue(null);
        if (value != null && value.length() > 0) {
            try {
                v = expressionEvaluator.evaluate(value);
            }
            catch (ExpressionEvaluationException e) {
                String msg = "Error evaluating the expression '" + value + "' for configuration value '" + configuration.getName() + "'";
                throw new ComponentConfigurationException(msg, e);
            }
        }
        if (v == null) {
            v = configuration.getAttribute("default-value", null);
        }
        return v;
    }

    public abstract /* synthetic */ Object fromConfiguration(ConverterLookup var1, PlexusConfiguration var2, Class var3, Class var4, ClassLoader var5, ExpressionEvaluator var6) throws ComponentConfigurationException;

    public abstract /* synthetic */ boolean canConvert(Class var1);
}

