/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkex.zul.impl;

import com.jhlabs.image.RippleFilter;
import com.jhlabs.image.ShadowFilter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import javax.imageio.ImageIO;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.Captcha;
import org.zkoss.zul.impl.CaptchaEngine;

public class JHLabsCaptchaEngine
implements CaptchaEngine,
Serializable {
    private static Random _random = new Random();
    private static final double[] sin = new double[]{Math.sin(Math.toRadians(0.0)), Math.sin(Math.toRadians(1.0)), Math.sin(Math.toRadians(2.0)), Math.sin(Math.toRadians(3.0)), Math.sin(Math.toRadians(4.0)), Math.sin(Math.toRadians(5.0))};
    private static final double[] cos = new double[]{Math.cos(Math.toRadians(0.0)), Math.cos(Math.toRadians(1.0)), Math.cos(Math.toRadians(2.0)), Math.cos(Math.toRadians(3.0)), Math.cos(Math.toRadians(4.0)), Math.cos(Math.toRadians(5.0))};

    public byte[] generateCaptcha(Object data) {
        Captcha captcha = (Captcha)data;
        BufferedImage bi = this.drawCaptcha(captcha);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (!ImageIO.write((RenderedImage)bi, "png", baos)) {
                throw new UiException("Don't know how to generate PNG");
            }
        }
        catch (IOException ex) {
            throw UiException.Aide.wrap((Throwable)ex);
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException ex) {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage drawCaptcha(Captcha captcha) {
        int width = captcha.getIntWidth();
        int height = captcha.getIntHeight();
        int bgRGB = captcha.getBgRGB();
        int fontRGB = captcha.getFontRGB();
        BufferedImage bi = new BufferedImage(width, height, 2);
        BufferedImage bitgt = new BufferedImage(width, height, 2);
        Graphics2D g2D = null;
        Graphics gtgt = null;
        try {
            g2D = bi.createGraphics();
            Color fontColor = new Color(fontRGB);
            g2D.setColor(fontColor);
            int textwidth = this.drawText(g2D, captcha);
            bi = this.distortion(bi);
            Color bgColor = new Color(bgRGB, false);
            GradientPaint grbgColor = new GradientPaint(0.0f, 0.0f, bgColor, width, height, Color.WHITE);
            gtgt = bitgt.createGraphics();
            ((Graphics2D)gtgt).setPaint(grbgColor);
            gtgt.fillRect(0, 0, width, height);
            int wgap = width - textwidth;
            int left = wgap <= 0 ? 0 : _random.nextInt(wgap);
            gtgt.drawImage(bi, left, 0, null);
            if (captcha.isNoise()) {
                this.genNoise(bitgt, 0.1f, 0.1f, 0.25f, 0.25f, fontColor);
                this.genNoise(bitgt, 0.1f, 0.25f, 0.5f, 0.9f, fontColor);
            }
            gtgt.setColor(fontColor);
            gtgt.drawRect(0, 0, width - 1, height - 1);
            BufferedImage bufferedImage = bitgt;
            return bufferedImage;
        }
        finally {
            if (g2D != null) {
                g2D.dispose();
            }
            if (gtgt != null) {
                gtgt.dispose();
            }
        }
    }

    protected int drawText(Graphics2D g2D, Captcha captcha) {
        int width = captcha.getIntWidth();
        int height = captcha.getIntHeight();
        String text = captcha.getValue();
        int len = text.length();
        int fontSize = captcha.getFonts().isEmpty() ? captcha.getDefaultFonts().length : captcha.getFonts().size();
        int bgRGB = captcha.getBgRGB();
        int fontRGB = captcha.getFontRGB();
        Color bgColor = new Color(bgRGB, true);
        Color fontColor = new Color(fontRGB);
        int avgwidth = width / len;
        int left = 0;
        int top = 0;
        int werror = 0;
        for (int j = 0; j < len; ++j) {
            Font font = captcha.getFont(_random.nextInt(fontSize));
            g2D.setFont(font);
            String substr = text.substring(j, j + 1);
            FontRenderContext frc = g2D.getFontRenderContext();
            Rectangle2D r2D = font.getStringBounds(substr, frc);
            BufferedImage charImg = this.rotateChar(substr, (int)r2D.getWidth(), (int)r2D.getHeight(), font, fontColor, bgColor);
            int charWidth = charImg.getWidth();
            int charHeight = charImg.getHeight();
            int wgap = avgwidth - charWidth + werror;
            if (wgap <= 0) {
                werror = wgap;
            }
            int hgap = height - charHeight;
            top = hgap <= 0 ? 0 : _random.nextInt(hgap);
            g2D.drawImage(charImg, left += wgap <= 0 ? 0 : _random.nextInt(wgap), top, bgColor, null);
            left += charWidth;
        }
        return left;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage rotateChar(String substr, int width, int height, Font font, Color fontColor, Color bgColor) {
        int angle = _random.nextInt(11) - 5;
        int[] resultxy = this.newXy(width, height, angle);
        int newWidth = resultxy[0];
        int newHeight = resultxy[1];
        Graphics g2D = null;
        try {
            BufferedImage bi = new BufferedImage(newWidth, newHeight, 2);
            g2D = bi.createGraphics();
            RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
            ((Graphics2D)g2D).setRenderingHints(hints);
            g2D.setColor(bgColor);
            g2D.fillRect(0, 0, newWidth, newHeight);
            g2D.setFont(font);
            int xRot = newWidth / 2;
            int yRot = newHeight / 2;
            AffineTransform xform = ((Graphics2D)g2D).getTransform();
            xform.rotate(Math.toRadians(angle), xRot, yRot);
            ((Graphics2D)g2D).setTransform(xform);
            g2D.setColor(fontColor);
            int left = (newWidth - width) / 2;
            int top = (newHeight - height) / 2 + height * 2 / 3;
            ((Graphics2D)g2D).drawString(substr, left, top);
            BufferedImage bufferedImage = bi;
            return bufferedImage;
        }
        finally {
            if (g2D != null) {
                g2D.dispose();
            }
        }
    }

    private BufferedImage distortion(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        RippleFilter rfilter = new RippleFilter();
        rfilter.setWaveType(0);
        rfilter.setXWavelength((float)(_random.nextInt(8) + 9));
        rfilter.setYWavelength((float)(_random.nextInt(3) + 2));
        rfilter.setXAmplitude(5.6f);
        rfilter.setYAmplitude(_random.nextFloat() + 1.0f);
        image = rfilter.filter(image, null);
        ShadowFilter sfilter = new ShadowFilter();
        sfilter.setRadius((float)(height / 4));
        image = sfilter.filter(image, null);
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genNoise(BufferedImage image, float factorOne, float factorTwo, float factorThree, float factorFour, Color fontColor) {
        int width = image.getWidth();
        int height = image.getHeight();
        CubicCurve2D.Float cc = new CubicCurve2D.Float((float)width * factorOne * _random.nextFloat(), (float)height * _random.nextFloat(), (float)width * factorTwo, (float)height * _random.nextFloat(), (float)width * factorThree, (float)height * _random.nextFloat(), (float)width * factorFour, (float)height * _random.nextFloat());
        PathIterator pathIt = cc.getPathIterator(null, 2.0);
        ArrayList<Point2D.Float> points = new ArrayList<Point2D.Float>(256);
        while (!pathIt.isDone()) {
            float[] coords = new float[6];
            switch (pathIt.currentSegment(coords)) {
                case 0: 
                case 1: {
                    points.add(new Point2D.Float(coords[0], coords[1]));
                }
            }
            pathIt.next();
        }
        Graphics2D g2D = null;
        try {
            g2D = (Graphics2D)image.getGraphics();
            g2D.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            g2D.setColor(fontColor);
            int count = points.size() - 1;
            for (int j = 0; j < count; ++j) {
                if (j < 3) {
                    g2D.setStroke(new BasicStroke(0.9f * (float)(3 - j)));
                }
                Point2D thisPoint = (Point2D)points.get(j);
                Point2D nextPoint = (Point2D)points.get(j + 1);
                g2D.drawLine((int)thisPoint.getX(), (int)thisPoint.getY(), (int)nextPoint.getX(), (int)nextPoint.getY());
            }
        }
        finally {
            if (g2D != null) {
                g2D.dispose();
            }
        }
    }

    private int[] newXy(int x, int y, int degree) {
        if (degree < 0) {
            degree = -degree;
            x = (int)((double)x * cos[degree] + (double)y * sin[degree]);
            y = (int)((double)y * cos[degree] - (double)x * sin[degree]);
        } else {
            x = (int)((double)x * cos[degree] - (double)y * sin[degree]);
            y = (int)((double)y * cos[degree] + (double)x * sin[degree]);
        }
        int[] result = new int[]{x, y};
        return result;
    }
}

