/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zhtml.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.zkoss.lang.Objects;
import org.zkoss.xml.XMLs;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.ext.DynamicPropertied;
import org.zkoss.zk.ui.ext.RawId;

public class AbstractTag
extends AbstractComponent
implements DynamicPropertied,
RawId {
    protected String _tagnm;
    private Map _props;
    private static final Set _childless = new HashSet(29);
    private static final EventInfo[] _evts;

    protected AbstractTag(String tagname) {
        if (tagname == null || tagname.length() == 0) {
            throw new IllegalArgumentException("A tag name is required");
        }
        this._tagnm = tagname;
    }

    protected AbstractTag() {
    }

    public String getSclass() {
        return (String)this.getDynamicProperty("class");
    }

    public void setSclass(String sclass) {
        this.setDynamicProperty("class", sclass);
    }

    public String getStyle() {
        return (String)this.getDynamicProperty("style");
    }

    public void setStyle(String style) {
        this.setDynamicProperty("style", style);
    }

    public String getTag() {
        return this._tagnm;
    }

    public boolean hasDynamicProperty(String name) {
        return name != null && !"use".equals(name) && !"if".equals(name) && !"unless".equals(name);
    }

    public Object getDynamicProperty(String name) {
        return this._props != null ? this._props.get(name) : null;
    }

    public void setDynamicProperty(String name, Object value) throws WrongValueException {
        if (name == null) {
            throw new WrongValueException("name is required");
        }
        if (!this.hasDynamicProperty(name)) {
            throw new WrongValueException("Attribute not allowed: " + name + "\nSpecify the ZK namespace if you want to use special ZK attributes");
        }
        String sval = Objects.toString((Object)value);
        if (sval == null) {
            if (this._props != null) {
                this._props.remove(name);
            }
        } else {
            if (this._props == null) {
                this._props = new HashMap();
            }
            this._props.put(name, sval);
        }
        this.smartUpdate(name, sval);
    }

    protected boolean shallHideId() {
        return false;
    }

    public boolean addEventListener(String evtnm, EventListener listener) {
        if (!listener.isAsap()) {
            throw new UiException("ZHTML accepts only ASAP listener");
        }
        int j = 0;
        while (true) {
            if (j >= _evts.length) {
                throw new UiException("Not supported event: " + evtnm);
            }
            if (_evts[j].name.equals(evtnm)) break;
            ++j;
        }
        EventInfo ei = _evts[j];
        boolean bAddType = ei.typed && !this.isTypeDeclared();
        boolean ret = super.addEventListener(evtnm, listener);
        if (ret) {
            this.smartUpdate(ei.attr, Events.isListenerAvailable((Component)this, (String)evtnm, (boolean)true) ? "true" : null);
            if (bAddType && this.isTypeDeclared()) {
                this.smartUpdate("z:type", "zhtml.main.Raw");
                this.smartUpdate("z:init", true);
            }
        }
        return ret;
    }

    private boolean isTypeDeclared() {
        for (int j = 0; j < _evts.length; ++j) {
            if (!_evts[j].typed || !Events.isListenerAvailable((Component)this, (String)_evts[j].name, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    public void redraw(Writer out) throws IOException {
        if (this._tagnm == null) {
            throw new UiException("The tag name is not initialized yet");
        }
        out.write(60);
        out.write(this._tagnm);
        if ("html".equals(this._tagnm)) {
            out.write(" xmlns:z=\"http://www.zkoss.org/2005/zk\"");
        }
        boolean typeDeclared = false;
        for (int j = 0; j < _evts.length; ++j) {
            if (!Events.isListenerAvailable((Component)this, (String)_evts[j].name, (boolean)true)) continue;
            if (_evts[j].typed) {
                typeDeclared = true;
            }
            out.write(32);
            out.write(_evts[j].attr);
            out.write("=\"true\"");
        }
        if (typeDeclared) {
            out.write(" z:type=\"zhtml.main.Raw\"");
        }
        if (typeDeclared || !this.shallHideId() || !Components.isAutoId((String)this.getUuid())) {
            out.write(" id=\"");
            out.write(this.getUuid());
            out.write(34);
        }
        if (this._props != null) {
            Iterator it = this._props.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                String key = (String)me.getKey();
                String val = (String)me.getValue();
                out.write(32);
                out.write(key);
                out.write("=\"");
                out.write(XMLs.encodeAttribute((String)val));
                out.write(34);
            }
        }
        if (this.isChildable()) {
            out.write(62);
            Iterator it = this.getChildren().iterator();
            while (it.hasNext()) {
                ((Component)it.next()).redraw(out);
            }
            out.write("</");
            out.write(this._tagnm);
            out.write(62);
        } else {
            out.write("/>");
        }
    }

    public boolean isChildable() {
        return !_childless.contains(this._tagnm);
    }

    public Object clone() {
        AbstractTag clone = (AbstractTag)((Object)super.clone());
        clone._props = new HashMap(clone._props);
        return clone;
    }

    public String toString() {
        return "[" + this._tagnm + ' ' + this.getId() + ']';
    }

    static {
        String[] childless = new String[]{"area", "base", "basefont", "bgsound", "br", "col", "colgroup", "embed", "hr", "img", "input", "isindex", "keygen", "link", "meta", "plaintext", "spacer", "wbr"};
        int j = childless.length;
        while (--j >= 0) {
            _childless.add(childless[j]);
        }
        _evts = new EventInfo[]{new EventInfo("onClick", "z:lfclk", false), new EventInfo("onChange", "z:onChange", true)};
    }

    private static class EventInfo {
        private final String name;
        private final String attr;
        private final boolean typed;

        private EventInfo(String name, String attr, boolean typed) {
            this.name = name;
            this.attr = attr;
            this.typed = typed;
        }
    }
}

