/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.parser;

import org.xhtmlrenderer.css.parser.FSColor;

public class FSCMYKColor
implements FSColor {
    private final float _cyan;
    private final float _magenta;
    private final float _yellow;
    private final float _black;

    public FSCMYKColor(float cyan, float magenta, float yellow, float black) {
        this._cyan = this.validateColor(cyan, "Cyan");
        this._magenta = this.validateColor(magenta, "Magenta");
        this._yellow = this.validateColor(yellow, "Yellow");
        this._black = this.validateColor(black, "Black");
    }

    private float validateColor(float c, String name) {
        if (c < 0.0f || c > 1.0f) {
            throw new IllegalArgumentException(String.format("%s %s is out of range [0, 1]", name, Float.valueOf(c)));
        }
        return c;
    }

    public float getCyan() {
        return this._cyan;
    }

    public float getMagenta() {
        return this._magenta;
    }

    public float getYellow() {
        return this._yellow;
    }

    public float getBlack() {
        return this._black;
    }

    public String toString() {
        return "cmyk(" + this._cyan + ", " + this._magenta + ", " + this._yellow + ", " + this._black + ")";
    }

    @Override
    public FSColor lightenColor() {
        return new FSCMYKColor(this._cyan * 0.8f, this._magenta * 0.8f, this._yellow * 0.8f, this._black);
    }

    @Override
    public FSColor darkenColor() {
        return new FSCMYKColor(Math.min(1.0f, this._cyan / 0.8f), Math.min(1.0f, this._magenta / 0.8f), Math.min(1.0f, this._yellow / 0.8f), this._black);
    }
}

