/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swing;

import java.awt.Image;
import java.awt.image.BufferedImage;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.util.Configuration;

public abstract class AWTFSImage
implements FSImage {
    public static FSImage createLegacyImage(Image img) {
        return new OldAWTFSImage(img);
    }

    public static FSImage createImage(Image img) {
        boolean useBufferedImage = Configuration.isTrue("xr.image.buffered", false);
        if (useBufferedImage) {
            return new NewAWTFSImage(img);
        }
        return new OldAWTFSImage(img);
    }

    protected AWTFSImage() {
    }

    public abstract Image getImage();

    static class NewAWTFSImage
    extends AWTFSImage {
        private Image img;

        public NewAWTFSImage(Image img) {
            this.img = img;
        }

        public int getWidth() {
            return this.img.getWidth(null);
        }

        public int getHeight() {
            return this.img.getHeight(null);
        }

        public Image getImage() {
            return this.img;
        }

        public void scale(int width, int height) {
            this.img = this.img.getScaledInstance(width, height, 1);
        }
    }

    static class OldAWTFSImage
    extends AWTFSImage {
        private Image img;

        public OldAWTFSImage(Image img) {
            if (img instanceof BufferedImage) {
                img = img.getScaledInstance(img.getWidth(null), img.getHeight(null), 2);
            }
            this.img = img;
        }

        public int getWidth() {
            return this.img.getWidth(null);
        }

        public int getHeight() {
            return this.img.getHeight(null);
        }

        public Image getImage() {
            return this.img;
        }

        public void scale(int width, int height) {
            this.img = this.img.getScaledInstance(width, height, 2);
        }
    }
}

