/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.provider.oscache;

import java.util.Arrays;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springmodules.cache.CachingModel;
import org.springmodules.util.Objects;

public class OsCacheCachingModel
implements CachingModel {
    private static final long serialVersionUID = 3904681574367770928L;
    private String cronExpression;
    private String[] groups;
    private Integer refreshPeriod;

    public OsCacheCachingModel() {
    }

    public OsCacheCachingModel(String csvGroups, int refreshPeriod) {
        this();
        this.setGroups(csvGroups);
        this.setRefreshPeriod(refreshPeriod);
    }

    public OsCacheCachingModel(String csvGroups, int refreshPeriod, String cronExpression) {
        this(csvGroups, new Integer(refreshPeriod), cronExpression);
    }

    public OsCacheCachingModel(String csvGroups, Integer refreshPeriod, String cronExpression) {
        this(csvGroups, cronExpression);
        this.setRefreshPeriod(refreshPeriod);
    }

    public OsCacheCachingModel(String csvGroups, String cronExpression) {
        this();
        this.setCronExpression(cronExpression);
        this.setGroups(csvGroups);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OsCacheCachingModel)) {
            return false;
        }
        OsCacheCachingModel cachingModel = (OsCacheCachingModel)obj;
        if (!ObjectUtils.nullSafeEquals((Object)this.cronExpression, (Object)cachingModel.cronExpression)) {
            return false;
        }
        if (!Arrays.equals(this.groups, cachingModel.groups)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.refreshPeriod, (Object)cachingModel.refreshPeriod);
    }

    public final String getCronExpression() {
        return this.cronExpression;
    }

    public final String[] getGroups() {
        return this.groups;
    }

    public final Integer getRefreshPeriod() {
        return this.refreshPeriod;
    }

    public int hashCode() {
        int multiplier = 31;
        int hash = 17;
        hash = multiplier * hash + Objects.nullSafeHashCode(this.cronExpression);
        hash = multiplier * hash + Objects.nullSafeHashCode(this.groups);
        hash = multiplier * hash + Objects.nullSafeHashCode(this.refreshPeriod);
        return hash;
    }

    public final void setCronExpression(String newCronExpression) {
        this.cronExpression = newCronExpression;
    }

    public final void setGroups(String csvGroups) {
        String[] newGroups = null;
        if (StringUtils.hasText((String)csvGroups)) {
            newGroups = StringUtils.commaDelimitedListToStringArray((String)csvGroups);
        }
        this.setGroups(newGroups);
    }

    public final void setGroups(String[] newGroups) {
        this.groups = newGroups;
    }

    public final void setRefreshPeriod(int newRefreshPeriod) {
        this.setRefreshPeriod(new Integer(newRefreshPeriod));
    }

    public final void setRefreshPeriod(Integer newRefreshPeriod) {
        this.refreshPeriod = newRefreshPeriod;
    }

    public String toString() {
        StringBuffer buffer = Objects.identityToString(this);
        buffer.append("[refreshPeriod=" + this.refreshPeriod + ", ");
        buffer.append("groups=" + Objects.nullSafeToString(this.groups) + ", ");
        buffer.append("cronExpression=" + StringUtils.quote((String)this.cronExpression) + "]");
        return buffer.toString();
    }
}

