/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.servlet.resource.ResourceUrlProvider;
import org.springframework.web.servlet.resource.ResourceUrlProviderExposingInterceptor;

public class ResourceUrlEncodingFilter
extends OncePerRequestFilter {
    private static final Log logger = LogFactory.getLog(ResourceUrlEncodingFilter.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        filterChain.doFilter((ServletRequest)request, (ServletResponse)new ResourceUrlEncodingResponseWrapper(request, response));
    }

    private static class ResourceUrlEncodingResponseWrapper
    extends HttpServletResponseWrapper {
        private final HttpServletRequest request;
        private Integer indexLookupPath;

        public ResourceUrlEncodingResponseWrapper(HttpServletRequest request, HttpServletResponse wrapped) {
            super(wrapped);
            this.request = request;
        }

        public String encodeURL(String url) {
            ResourceUrlProvider resourceUrlProvider = this.getResourceUrlProvider();
            if (resourceUrlProvider == null) {
                logger.debug((Object)"Request attribute exposing ResourceUrlProvider not found");
                return super.encodeURL(url);
            }
            this.initIndexLookupPath(resourceUrlProvider);
            if (url.length() >= this.indexLookupPath) {
                String prefix = url.substring(0, this.indexLookupPath);
                int suffixIndex = this.getQueryParamsIndex(url);
                String suffix = url.substring(suffixIndex);
                String lookupPath = url.substring(this.indexLookupPath, suffixIndex);
                if ((lookupPath = resourceUrlProvider.getForLookupPath(lookupPath)) != null) {
                    return super.encodeURL(prefix + lookupPath + suffix);
                }
            }
            return super.encodeURL(url);
        }

        private ResourceUrlProvider getResourceUrlProvider() {
            return (ResourceUrlProvider)this.request.getAttribute(ResourceUrlProviderExposingInterceptor.RESOURCE_URL_PROVIDER_ATTR);
        }

        private void initIndexLookupPath(ResourceUrlProvider urlProvider) {
            if (this.indexLookupPath == null) {
                String contextPath;
                String requestUri = urlProvider.getPathHelper().getRequestUri(this.request);
                String lookupPath = urlProvider.getPathHelper().getLookupPathForRequest(this.request);
                this.indexLookupPath = requestUri.lastIndexOf(lookupPath);
                if ("/".equals(lookupPath) && !"/".equals(requestUri) && requestUri.equals(contextPath = urlProvider.getPathHelper().getContextPath(this.request))) {
                    this.indexLookupPath = requestUri.length();
                }
            }
        }

        private int getQueryParamsIndex(String url) {
            int index = url.indexOf("?");
            return index > 0 ? index : url.length();
        }
    }
}

